/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.lib.commons.reman.readers;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import pl.com.stream.lib.commons.reman.readers.ResourceReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceReaderRegister {
    private static final Logger log = Logger.getLogger(ResourceReaderRegister.class);
    private Map<Class<?>, ResourceReader> readerMap;

    public ResourceReader getReader(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        ResourceReader resourceReader = this.getReaderMap().get(clazz);
        if (resourceReader == null) {
            Set<Class<?>> set = this.getReaderMap().keySet();
            for (Class<?> clazz2 : set) {
                try {
                    clazz.asSubclass(clazz2);
                    return this.getReaderMap().get(clazz2);
                }
                catch (ClassCastException classCastException) {
                }
            }
        }
        if (resourceReader == null) {
            log.warn("Resource reader for class: " + clazz + " not registred.");
        }
        return resourceReader;
    }

    public Collection<ResourceReader> getReaders() {
        return this.getReaderMap().values();
    }

    public void registerReader(Class<?> clazz, ResourceReader resourceReader) {
        if (this.getReaderMap().containsKey(clazz)) {
            throw new IllegalArgumentException("Resource reader for class: " + clazz.getName() + " already registred.");
        }
        resourceReader.setResourceReaderRegister(this);
        this.getReaderMap().put(clazz, resourceReader);
    }

    private Map<Class<?>, ResourceReader> getReaderMap() {
        if (this.readerMap == null) {
            this.readerMap = new HashMap();
        }
        return this.readerMap;
    }
}

