/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.lib.commons.reman.readers;

import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;
import pl.com.stream.lib.commons.reman.readers.AbstractResourceReader;
import pl.com.stream.lib.commons.reman.resourcetree.ResourceNode;

public class ImageResourceReader
extends AbstractResourceReader {
    private static final Logger log = Logger.getLogger(ImageResourceReader.class);

    public Object read(ResourceNode resourceNode) {
        Object object;
        String string = resourceNode.getValue();
        ClassLoader classLoader = resourceNode.getRepositoryDescription().getClassLoader();
        if (string == null) {
            log.warn("Image path not secified.");
            return null;
        }
        if (classLoader == null) {
            log.warn("Class loader not secified.");
            return null;
        }
        if (!string.startsWith("/")) {
            string = resourceNode.getRepositoryDescription().getPath() + "/" + string;
        }
        if ((object = this.get(string = this.resolvePath(string), classLoader)) == null) {
            try {
                InputStream inputStream = classLoader.getResourceAsStream(string);
                if (inputStream != null) {
                    log.debug("Reading image: " + string);
                    object = ImageIO.read(inputStream);
                    this.store(string, classLoader, object);
                } else {
                    log.warn("Resource: " + string + " not found.");
                }
            }
            catch (IOException iOException) {
                log.error("Error while reading resource: " + string, iOException);
            }
        }
        return object;
    }
}

