/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.lib.commons.reman.readers;

import java.awt.Font;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import pl.com.stream.lib.commons.reman.readers.AbstractResourceReader;
import pl.com.stream.lib.commons.reman.resourcetree.ResourceNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontResourceReader
extends AbstractResourceReader {
    private static final Logger log = Logger.getLogger(FontResourceReader.class);
    private Map<String, Integer> stypeMap;

    private Map<String, Integer> getStyleMap() {
        if (this.stypeMap == null) {
            this.stypeMap = new HashMap<String, Integer>();
            this.stypeMap.put("bold", 1);
            this.stypeMap.put("bolditalic", 3);
            this.stypeMap.put("italic", 2);
            this.stypeMap.put("plain", 0);
        }
        return this.stypeMap;
    }

    @Override
    public Object read(ResourceNode resourceNode) {
        Map<String, ResourceNode> map = resourceNode.getChildrens();
        String string = null;
        String string2 = null;
        String string3 = null;
        if (map != null) {
            ResourceNode resourceNode2 = map.get("name");
            ResourceNode resourceNode3 = map.get("size");
            ResourceNode resourceNode4 = map.get("style");
            if (resourceNode2 != null) {
                string = resourceNode2.getValue();
            }
            if (resourceNode3 != null) {
                string2 = resourceNode3.getValue();
            }
            if (resourceNode4 != null) {
                string3 = resourceNode4.getValue();
            }
        } else if (resourceNode.getValue() != null) {
            String[] stringArray = resourceNode.getValue().split(";");
            if (stringArray.length != 3) {
                log.warn("Wrong font format: " + resourceNode.getValue());
                return null;
            }
            string = stringArray[0];
            string2 = stringArray[1];
            string3 = stringArray[2];
        } else {
            log.warn("Wrong font format: " + resourceNode.getValue());
            return null;
        }
        return this.getFont(string, string2, string3);
    }

    private Font getFont(String string, String string2, String string3) {
        Object object;
        Object object2;
        String string4 = "Arial";
        int n = 12;
        int n2 = 0;
        if (string != null) {
            string4 = string;
        }
        if (string2 != null) {
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                log.warn("Wrong font size format.", numberFormatException);
            }
        }
        if (string3 != null) {
            object = object2 = string3 != null ? string3.split(",") : new String[]{};
            int n3 = ((String[])object).length;
            for (int i = 0; i < n3; ++i) {
                String string5 = object[i];
                Integer n4 = this.getStyleMap().get(string5.toLowerCase());
                if (n4 == null) continue;
                n2 |= n4.intValue();
            }
        }
        if ((object = this.get((String)(object2 = string4 + "|" + n + "|" + n2))) == null) {
            object = new Font(string4, n2, n);
            this.store((String)object2, object);
        }
        return (Font)object;
    }
}

