/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.lib.commons.reman.readers;

import java.applet.Applet;
import java.io.InputStream;
import org.apache.log4j.Logger;
import pl.com.stream.lib.commons.reman.readers.AbstractResourceReader;
import pl.com.stream.lib.commons.reman.resourcetree.ResourceNode;

public class AudioClipResourceReader
extends AbstractResourceReader {
    private static final Logger log = Logger.getLogger(AudioClipResourceReader.class);

    public Object read(ResourceNode resourceNode) {
        Object object;
        String string = resourceNode.getValue();
        ClassLoader classLoader = resourceNode.getRepositoryDescription().getClassLoader();
        if (string == null) {
            log.warn("Audio clip path not secified.");
            return null;
        }
        if (classLoader == null) {
            log.warn("Class loader not secified.");
            return null;
        }
        if (!string.startsWith("/")) {
            string = resourceNode.getRepositoryDescription().getPath() + "/" + string;
        }
        if ((object = this.get(string, classLoader)) == null) {
            InputStream inputStream = classLoader.getResourceAsStream(string);
            if (inputStream != null) {
                log.debug("Reading audio clip: " + string);
                object = Applet.newAudioClip(classLoader.getResource(string));
                this.store(string, classLoader, object);
            } else {
                log.warn("Resource: " + string + " not found.");
            }
        }
        return object;
    }
}

