/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.lib.commons.reman;

import java.applet.AudioClip;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.apache.log4j.Logger;
import pl.com.stream.lib.commons.reman.DefaultResourceFacade;
import pl.com.stream.lib.commons.reman.DefaultResourceNode;
import pl.com.stream.lib.commons.reman.annotations.ResourceContainer;
import pl.com.stream.lib.commons.reman.facade.ResourceFacade;
import pl.com.stream.lib.commons.reman.readers.AbstractResourceReader;
import pl.com.stream.lib.commons.reman.readers.AudioClipResourceReader;
import pl.com.stream.lib.commons.reman.readers.BigDecimalResourceReader;
import pl.com.stream.lib.commons.reman.readers.BigIntegerResourceReader;
import pl.com.stream.lib.commons.reman.readers.BooleanResourceReader;
import pl.com.stream.lib.commons.reman.readers.ByteResourceReader;
import pl.com.stream.lib.commons.reman.readers.CharacterResourceReader;
import pl.com.stream.lib.commons.reman.readers.ColorResourceReader;
import pl.com.stream.lib.commons.reman.readers.DoubleResourceReader;
import pl.com.stream.lib.commons.reman.readers.FloatResourceReader;
import pl.com.stream.lib.commons.reman.readers.FontResourceReader;
import pl.com.stream.lib.commons.reman.readers.ImageIconResourceReader;
import pl.com.stream.lib.commons.reman.readers.ImageResourceReader;
import pl.com.stream.lib.commons.reman.readers.IntegerResourceReader;
import pl.com.stream.lib.commons.reman.readers.LongResourceReader;
import pl.com.stream.lib.commons.reman.readers.ResourceReader;
import pl.com.stream.lib.commons.reman.readers.ResourceReaderRegister;
import pl.com.stream.lib.commons.reman.readers.ShortResourceReader;
import pl.com.stream.lib.commons.reman.readers.StringResourceReader;
import pl.com.stream.lib.commons.reman.repository.LocalRepositoryDescription;
import pl.com.stream.lib.commons.reman.repository.RepositoryDescription;
import pl.com.stream.lib.commons.reman.repository.RepositoryRegister;
import pl.com.stream.lib.commons.reman.resourcetree.ResourceNode;
import pl.com.stream.lib.commons.reman.variable.VariableRegister;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceManager {
    public static final String DEFAULT_RESOURCES_DIR = "resources";
    public static final String RESOURCES_MAP_FILE = "Package";
    private static Logger log = Logger.getLogger(ResourceManager.class);
    private Set<Object> fileResourceMap;
    private final String groupNameRegEx = ".*?\\.";
    private final Pattern groupNamePattern = Pattern.compile(".*?\\.");
    private Locale locale;
    private ResourceReaderRegister readerRegister;
    private final String repositoryRegEx = "\\$\\{.*?\\}";
    private final Pattern repositoryPattern = Pattern.compile("\\$\\{.*?\\}");
    private RepositoryRegister repositoryRegister;
    private final String variableRegEx = "#\\{.*?\\}";
    private final Pattern variablePattern = Pattern.compile("#\\{.*?\\}");
    private VariableRegister variableRegister;

    public static void bind(Class<?> clazz) {
        ResourceManager resourceManager = ResourceManager.getInstance();
        resourceManager.bindResources(clazz, resourceManager.getLocale());
    }

    public static void bind(Class<?> clazz, Locale locale) {
        ResourceManager.getInstance().bindResources(clazz, locale);
    }

    public static void bind(Object object) {
        ResourceManager.bind(object, ResourceManager.getInstance().getLocale());
    }

    public static void bind(Object object, Locale locale) {
        ResourceManager.getInstance().bindResources(object, locale);
    }

    public static ResourceManager getInstance() {
        return ResourceManagerHandler.INSTANCE;
    }

    private ResourceManager() {
        this.registerReader(Byte.class, new ByteResourceReader());
        this.registerReader(Byte.TYPE, new ByteResourceReader());
        this.registerReader(Short.class, new ShortResourceReader());
        this.registerReader(Short.TYPE, new ShortResourceReader());
        this.registerReader(Integer.class, new IntegerResourceReader());
        this.registerReader(Integer.TYPE, new IntegerResourceReader());
        this.registerReader(Long.class, new LongResourceReader());
        this.registerReader(Long.TYPE, new LongResourceReader());
        this.registerReader(Float.class, new FloatResourceReader());
        this.registerReader(Float.TYPE, new FloatResourceReader());
        this.registerReader(Double.class, new DoubleResourceReader());
        this.registerReader(Double.TYPE, new DoubleResourceReader());
        this.registerReader(BigDecimal.class, new BigDecimalResourceReader());
        this.registerReader(BigInteger.class, new BigIntegerResourceReader());
        this.registerReader(Boolean.class, new BooleanResourceReader());
        this.registerReader(Boolean.TYPE, new BooleanResourceReader());
        this.registerReader(Character.class, new CharacterResourceReader());
        this.registerReader(Character.TYPE, new CharacterResourceReader());
        this.registerReader(String.class, new StringResourceReader());
        this.registerReader(Icon.class, new ImageIconResourceReader());
        this.registerReader(Image.class, new ImageResourceReader());
        this.registerReader(Font.class, new FontResourceReader());
        this.registerReader(Color.class, new ColorResourceReader());
        this.registerReader(AudioClip.class, new AudioClipResourceReader());
    }

    public void clear() {
        Collection<ResourceReader> collection = this.getReaderRegister().getReaders();
        for (ResourceReader resourceReader : collection) {
            if (!(resourceReader instanceof AbstractResourceReader)) continue;
            AbstractResourceReader abstractResourceReader = (AbstractResourceReader)resourceReader;
            abstractResourceReader.clear();
        }
    }

    public ResourceFacade getResourceFacade(Class<?> clazz) {
        String string = this.getPropertyFile(clazz);
        ClassLoader classLoader = clazz.getClassLoader();
        return this.getResourceFacade(string, this.getLocale(), classLoader);
    }

    public ResourceFacade getResourceFacade(Class<?> clazz, Locale locale) {
        String string = this.getPropertyFile(clazz);
        ClassLoader classLoader = clazz.getClassLoader();
        return this.getResourceFacade(string, locale, classLoader);
    }

    public ResourceFacade getResourceFacade(String string) {
        return this.getResourceFacade(string, this.getLocale(), this.getClass().getClassLoader());
    }

    public ResourceFacade getResourceFacade(String string, ClassLoader classLoader) {
        return this.getResourceFacade(string, this.getLocale(), classLoader);
    }

    public ResourceFacade getResourceFacade(String string, Locale locale, ClassLoader classLoader) {
        return new DefaultResourceFacade(this, locale, string, classLoader);
    }

    public boolean isResourceExists(Class<?> clazz, Locale locale) {
        try {
            String string = this.getPropertyFile(clazz);
            ClassLoader classLoader = clazz.getClassLoader();
            ResourceBundle.getBundle(string, locale, classLoader);
        }
        catch (MissingResourceException missingResourceException) {
            return false;
        }
        return true;
    }

    public void registerReader(Class<?> clazz, ResourceReader resourceReader) {
        this.getReaderRegister().registerReader(clazz, resourceReader);
    }

    public void registerRepository(String string, String string2) {
        this.getRepositoryRegister().registerRepository(string, string2);
    }

    public void registerRepository(String string, String string2, ClassLoader classLoader) {
        this.getRepositoryRegister().registerRepository(string, string2, classLoader);
    }

    public void registerTypeAsFileResource(Class<?> clazz) {
        this.getFileResourceSet().add(clazz);
    }

    public void registerTypeAsFileResource(String string) {
        this.getFileResourceSet().add(string);
    }

    public void registerVariable(String string, String string2) {
        this.getVariableRegister().registerVariable(string, string2);
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    private void bindResources(Class<?> clazz, Locale locale) {
        Class<?>[] classArray = clazz.getDeclaredClasses();
        LocalRepositoryDescription localRepositoryDescription = null;
        for (Class<?> clazz2 : classArray) {
            ClassLoader classLoader;
            String string;
            if (!clazz2.isAnnotationPresent(ResourceContainer.class)) continue;
            if (localRepositoryDescription == null && (localRepositoryDescription = new LocalRepositoryDescription(string = this.getPropertyFile(clazz), locale, classLoader = clazz.getClassLoader())).getResourceBundle() == null) {
                log.warn("Can not bind resources for class: " + clazz.getName() + ", resource bundle not found.");
                return;
            }
            this.fillResourceContainer(clazz2, localRepositoryDescription);
        }
    }

    private void bindResources(Object object, Locale locale) {
        if (object == null) {
            log.warn("Can not load resources. Binding object can not be null!");
            return;
        }
        long l = System.currentTimeMillis();
        for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            this.bindResources(object, locale, clazz);
        }
        log.debug("Dynammic resources for class: " + object.getClass().getName() + " loaded in: " + (System.currentTimeMillis() - l) + " ms");
    }

    private void bindResources(Object object, Locale locale, Class<?> clazz) {
        Field[] fieldArray = clazz.getDeclaredFields();
        LocalRepositoryDescription localRepositoryDescription = null;
        for (Field field : fieldArray) {
            ClassLoader classLoader;
            String string;
            if (!field.isAnnotationPresent(ResourceContainer.class)) continue;
            if (localRepositoryDescription == null && (localRepositoryDescription = new LocalRepositoryDescription(string = this.getPropertyFile(clazz), locale, classLoader = clazz.getClassLoader())).getResourceBundle() == null) {
                log.warn("Can not bind resources for class: " + clazz.getName() + ", resource bundle not found.");
                return;
            }
            this.fillResourceContainer(field, object, clazz, localRepositoryDescription);
        }
    }

    private void createResourceNodeTree(ResourceNode resourceNode, List<ResourceValue> list, RepositoryDescription repositoryDescription, RepositoryVariableDictionary repositoryVariableDictionary) {
        if (list.size() == 1) {
            ResourceValue resourceValue = list.get(0);
            String string = this.replaceVariables(resourceValue.getValue());
            Matcher matcher = this.repositoryPattern.matcher(string);
            if (matcher.find()) {
                String object2 = matcher.group();
                String object = object2.substring(2, object2.length() - 1);
                if (string.endsWith("}")) {
                    if (repositoryVariableDictionary.contains(repositoryDescription, object)) {
                        log.warn("Recurency stack overflow problem with repository: " + object);
                        return;
                    }
                    String[] string6 = object.split(":");
                    if (string6.length > 2) {
                        log.warn("Wrong repository format: " + object2);
                        return;
                    }
                    RepositoryDescription repositoryDescription3 = null;
                    String string2 = null;
                    if (string6.length == 1) {
                        string2 = string6[0];
                        repositoryDescription3 = repositoryDescription;
                    } else {
                        repositoryDescription3 = this.getRepository(string6[0]);
                        if (repositoryDescription3 == null) {
                            log.warn("Repository: " + string6[0] + " not registred.");
                            return;
                        }
                        string2 = string6[1];
                    }
                    List<ResourceValue> list2 = this.getResourceValueList(string2, repositoryDescription3.getPackageBundle());
                    String string3 = null;
                    if (list2 == null) {
                        return;
                    }
                    if (list2.size() == 1) {
                        string3 = list.get(0).getValue();
                    }
                    DefaultResourceNode defaultResourceNode = new DefaultResourceNode(string2, string3, repositoryDescription3);
                    resourceNode.addChild(defaultResourceNode);
                    this.createResourceNodeTree(defaultResourceNode, list2, repositoryDescription3, repositoryVariableDictionary);
                } else {
                    String list3 = string.substring(object2.length());
                    if (list3.startsWith("/")) {
                        list3 = list3.substring(1);
                    }
                    if ((string = this.getRepository(object)) == null) {
                        log.warn("Repository: " + object + " not registred.");
                        return;
                    }
                    resourceNode.setValue(list3);
                    resourceNode.setRepositoryDescription(string);
                }
            } else {
                resourceNode.setValue(string);
            }
        } else {
            Object object;
            Object object2;
            HashMap<Object, List<ResourceValue>> hashMap = null;
            for (ResourceValue object3 : list) {
                List<ResourceValue> list3;
                object2 = this.groupNamePattern.matcher(object3.getName());
                if (((Matcher)object2).find()) {
                    if (hashMap == null) {
                        hashMap = new HashMap<Object, List<ResourceValue>>();
                    }
                    if ((list3 = (List)hashMap.get(object = ((Matcher)object2).group().substring(0, ((Matcher)object2).group().length() - 1))) == null) {
                        list3 = new ArrayList();
                        hashMap.put(object, list3);
                    }
                    String string = object3.getName().substring(((Matcher)object2).group().length());
                    list3.add(new ResourceValue(string, object3.getValue()));
                    continue;
                }
                object = new DefaultResourceNode(object3.getName(), object3.getValue(), repositoryDescription);
                resourceNode.addChild((ResourceNode)object);
                list3 = new ArrayList();
                list3.add(object3);
                this.createResourceNodeTree((ResourceNode)object, list3, repositoryDescription, repositoryVariableDictionary);
            }
            if (hashMap != null) {
                Set set = hashMap.keySet();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    object2 = (String)iterator.next();
                    object = new DefaultResourceNode((String)object2, null, repositoryDescription);
                    resourceNode.addChild((ResourceNode)object);
                    this.createResourceNodeTree((ResourceNode)object, (List)hashMap.get(object2), repositoryDescription, repositoryVariableDictionary);
                }
            }
        }
    }

    private void fillField(Field field, Object object) {
        this.fillField(field, field, object);
    }

    private void fillField(Field field, Object object, Object object2) {
        try {
            field.setAccessible(true);
            field.set(object, object2);
        }
        catch (Exception exception) {
            log.error("Can not set field value: " + exception.getMessage(), exception);
        }
    }

    private void fillResourceContainer(Class<?> clazz, LocalRepositoryDescription localRepositoryDescription) {
        Field[] fieldArray;
        for (Field field : fieldArray = clazz.getDeclaredFields()) {
            String string = field.getName();
            Class<?> clazz2 = field.getType();
            Object object = this.getResource(string, clazz2, localRepositoryDescription);
            this.fillField(field, object);
        }
    }

    private void fillResourceContainer(Field field, Object object, Class<?> clazz, LocalRepositoryDescription localRepositoryDescription) {
        try {
            Object object2;
            field.setAccessible(true);
            Class<?> clazz2 = field.getType();
            Object object3 = field.get(object);
            if (object3 == null) {
                object2 = clazz2.getDeclaredConstructor(clazz);
                ((Constructor)object2).setAccessible(true);
                object3 = ((Constructor)object2).newInstance(object);
                this.fillField(field, object, object3);
            }
            object2 = clazz2.getDeclaredFields();
            for (Field field2 : object2) {
                field2.setAccessible(true);
                String string = field2.getName();
                Class<?> clazz3 = field2.getType();
                Object object4 = field2.get(object3);
                if (object4 == object) continue;
                Object object5 = this.getResource(string, clazz3, localRepositoryDescription);
                this.fillField(field2, object3, object5);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.error(illegalArgumentException.getMessage(), illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            log.error(illegalAccessException.getMessage(), illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            log.error(instantiationException.getMessage(), instantiationException);
        }
        catch (SecurityException securityException) {
            log.error(securityException.getMessage(), securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            log.error(noSuchMethodException.getMessage(), noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            log.error(invocationTargetException.getMessage(), invocationTargetException);
        }
    }

    private Set<Object> getFileResourceSet() {
        if (this.fileResourceMap == null) {
            this.fileResourceMap = new HashSet<Object>();
        }
        return this.fileResourceMap;
    }

    private Locale getLocale() {
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        return this.locale;
    }

    private String getPropertyFile(Class<?> clazz) {
        String string = clazz.getSimpleName();
        String string2 = this.getResourcesPath(clazz);
        StringBuffer stringBuffer = new StringBuffer(string2);
        stringBuffer.append(".").append(string);
        return stringBuffer.toString();
    }

    private ResourceReaderRegister getReaderRegister() {
        if (this.readerRegister == null) {
            this.readerRegister = new ResourceReaderRegister();
        }
        return this.readerRegister;
    }

    private RepositoryDescription getRepository(String string) {
        return this.getRepositoryRegister().getRepository(string);
    }

    private RepositoryRegister getRepositoryRegister() {
        if (this.repositoryRegister == null) {
            this.repositoryRegister = new RepositoryRegister();
        }
        return this.repositoryRegister;
    }

    private ResourceReader getResourceReader(Class<?> clazz) {
        return this.getReaderRegister().getReader(clazz);
    }

    private String getResourcesPath(Class<?> clazz) {
        String string = clazz.getName();
        String string2 = clazz.getSimpleName();
        String string3 = "";
        if (string.indexOf(".") != -1) {
            string3 = string.substring(0, string.indexOf(string2));
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string3).append(DEFAULT_RESOURCES_DIR);
        return stringBuffer.toString();
    }

    private List<ResourceValue> getResourceValueList(String string, RepositoryDescription.ResourceBundleDescription resourceBundleDescription) {
        ArrayList<ResourceValue> arrayList = null;
        String string2 = resourceBundleDescription.getFile();
        Set<String> set = resourceBundleDescription.getKeySet();
        boolean bl = false;
        for (String string3 : set) {
            String string4 = null;
            if (string3.equals(string)) {
                string4 = "";
                bl = true;
            } else if (string3.startsWith(string + ".")) {
                string4 = string3.substring(string.length() + 1);
            }
            if (string4 == null) continue;
            String string5 = resourceBundleDescription.getString(string3);
            if (arrayList == null) {
                arrayList = new ArrayList<ResourceValue>();
            }
            arrayList.add(new ResourceValue(string4, string5));
        }
        if (arrayList == null) {
            log.warn("Can not find key: " + string + " inside resource file: " + string2);
            return null;
        }
        if (bl && arrayList.size() > 1) {
            log.warn("Wrong resource declaration: " + string);
            return null;
        }
        return arrayList;
    }

    private String getVariable(String string) {
        return this.getVariableRegister().getVariable(string);
    }

    private VariableRegister getVariableRegister() {
        if (this.variableRegister == null) {
            this.variableRegister = new VariableRegister();
        }
        return this.variableRegister;
    }

    private void reduceTree(ResourceNode resourceNode) {
        block4: {
            Map<String, ResourceNode> map = resourceNode.getChildrens();
            if (map == null) break block4;
            if (map.size() == 1) {
                Set<String> set = map.keySet();
                for (String string : set) {
                    ResourceNode resourceNode2 = map.get(string);
                    resourceNode.setChildrens(resourceNode2.getChildrens());
                    resourceNode.setRepositoryDescription(resourceNode2.getRepositoryDescription());
                    resourceNode.setValue(resourceNode2.getValue());
                    this.reduceTree(resourceNode);
                }
            } else {
                Set<String> set = map.keySet();
                for (String string : set) {
                    ResourceNode resourceNode3 = map.get(string);
                    this.reduceTree(resourceNode3);
                }
            }
        }
    }

    private String replaceVariables(String string) {
        Matcher matcher = this.variablePattern.matcher(string);
        while (matcher.find()) {
            String string2 = matcher.group();
            string2 = string2.substring(2, string2.length() - 1);
            string = matcher.replaceFirst(this.getVariable(string2));
            matcher.reset(string);
        }
        return string;
    }

    Object getResource(String string, Class<?> clazz, LocalRepositoryDescription localRepositoryDescription) {
        DefaultResourceNode defaultResourceNode = null;
        try {
            List<ResourceValue> list = this.getResourceValueList(string, localRepositoryDescription.getResourceBundle());
            if (list == null) {
                return null;
            }
            String string2 = null;
            if (list.size() == 1) {
                string2 = list.get(0).getValue();
            }
            defaultResourceNode = new DefaultResourceNode(string, string2, localRepositoryDescription);
            this.createResourceNodeTree(defaultResourceNode, list, localRepositoryDescription, new RepositoryVariableDictionary());
            this.reduceTree(defaultResourceNode);
            ResourceReader resourceReader = this.getResourceReader(clazz);
            if (resourceReader == null) {
                log.warn("Resource reader for class: " + clazz.getName() + " not found.");
                return null;
            }
            return resourceReader.read(defaultResourceNode);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.error(illegalArgumentException.getMessage(), illegalArgumentException);
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), exception);
        }
        return null;
    }

    private class ResourceValue {
        private final String name;
        private final String value;

        public ResourceValue(String string, String string2) {
            this.name = string;
            this.value = string2;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }

    private static class ResourceManagerHandler {
        private static ResourceManager INSTANCE = new ResourceManager();

        private ResourceManagerHandler() {
        }
    }

    private class RepositoryVariableDictionary {
        private final Map<RepositoryDescription, Set<String>> map = new HashMap<RepositoryDescription, Set<String>>();

        private RepositoryVariableDictionary() {
        }

        public boolean contains(RepositoryDescription repositoryDescription, String string) {
            Set<String> set = this.map.get(repositoryDescription);
            if (set != null) {
                if (set.contains(string)) {
                    return true;
                }
                set.add(string);
                return false;
            }
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(string);
            this.map.put(repositoryDescription, hashSet);
            return false;
        }
    }
}

