/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.lib.commons.persistence.impl;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import pl.com.stream.lib.commons.persistence.PersistenceNode;
import pl.com.stream.lib.commons.persistence.impl.AbstractPersistenceService;
import pl.com.stream.lib.commons.persistence.impl.PersistenceNodeImpl;

public class PersistenceServiceXML
extends AbstractPersistenceService {
    public void persistNodes(PersistenceNode persistenceNode, OutputStream outputStream) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.transform(new DOMSource(this.createDocument(persistenceNode)), new StreamResult(outputStream));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public PersistenceNode readNodes(InputStream inputStream) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            Element element = document.getDocumentElement();
            PersistenceNodeImpl persistenceNodeImpl = new PersistenceNodeImpl(element.getNodeName());
            this.createChildPersistenceNode(persistenceNodeImpl, element);
            return persistenceNodeImpl;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private void createChildPersistenceNode(PersistenceNode persistenceNode, Element element) {
        Node node;
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node2 = namedNodeMap.item(i);
            if (!(node2 instanceof Attr)) continue;
            node = (Attr)node2;
            persistenceNode.setAttribute(node.getNodeName(), node.getValue());
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element element2 = (Element)node;
            this.createChildPersistenceNode(persistenceNode.createChildNode(element2.getNodeName()), element2);
        }
    }

    private Document createDocument(PersistenceNode persistenceNode) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement(persistenceNode.getName());
            document.appendChild(element);
            this.createChildsElement(persistenceNode, element, document);
            return document;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private void createChildsElement(PersistenceNode persistenceNode, Element element, Document document) {
        Object object;
        Object object2;
        Map<String, String> map = persistenceNode.getAttributesMap();
        if (map != null) {
            object2 = map.keySet().iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                element.setAttribute((String)object, map.get(object));
            }
        }
        if ((object2 = persistenceNode.getChildsNodeList()) != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                PersistenceNode persistenceNode2 = (PersistenceNode)object.next();
                Element element2 = document.createElement(persistenceNode2.getName());
                element.appendChild(element2);
                this.createChildsElement(persistenceNode2, element2, document);
            }
        }
    }
}

