/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.lib.commons.persistence.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import pl.com.stream.lib.commons.persistence.PersistenceNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceNodeImpl
implements PersistenceNode {
    private static final Logger logger = Logger.getLogger(PersistenceNodeImpl.class);
    private final String name;
    private Map<String, String> attributesMap;
    private List<PersistenceNode> childsList;

    public PersistenceNodeImpl(String string) {
        this.name = string;
    }

    @Override
    public PersistenceNode createChildNode(String string) {
        if (this.childsList == null) {
            this.childsList = new ArrayList<PersistenceNode>();
        }
        PersistenceNodeImpl persistenceNodeImpl = new PersistenceNodeImpl(string);
        this.childsList.add(persistenceNodeImpl);
        return persistenceNodeImpl;
    }

    @Override
    public String getAttribute(String string) {
        if (this.attributesMap == null) {
            return null;
        }
        return this.attributesMap.get(string);
    }

    @Override
    public Map<String, String> getAttributesMap() {
        return this.attributesMap;
    }

    @Override
    public List<PersistenceNode> getChildNodeList(String string) {
        ArrayList<PersistenceNode> arrayList = new ArrayList<PersistenceNode>();
        if (this.childsList == null) {
            return arrayList;
        }
        for (PersistenceNode persistenceNode : this.childsList) {
            if (!persistenceNode.getName().equals(string)) continue;
            arrayList.add(persistenceNode);
        }
        return arrayList;
    }

    @Override
    public List<PersistenceNode> getChildsNodeList() {
        ArrayList<PersistenceNode> arrayList = new ArrayList<PersistenceNode>();
        if (this.childsList == null) {
            return arrayList;
        }
        for (PersistenceNode persistenceNode : this.childsList) {
            arrayList.add(persistenceNode);
        }
        return arrayList;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setAttribute(String string, String string2) {
        if (this.attributesMap == null) {
            this.attributesMap = new HashMap<String, String>();
        }
        this.attributesMap.put(string, string2);
    }

    @Override
    public PersistenceNode getFirstChildNode(String string) {
        List<PersistenceNode> list = this.getChildNodeList(string);
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Integer getIntegerAtr(String string) {
        String string2 = this.getAttribute(string);
        if (string2 != null) {
            try {
                return Integer.parseInt(string2);
            }
            catch (Exception exception) {
                logger.warn("Unable to parse integer attribute " + string, exception);
            }
        }
        return null;
    }

    @Override
    public void setIntegerAtr(String string, Integer n) {
        this.setAttribute(string, String.valueOf(n));
    }

    @Override
    public void addChildNode(PersistenceNode persistenceNode) {
        if (this.childsList == null) {
            this.childsList = new ArrayList<PersistenceNode>();
        }
        this.childsList.add(persistenceNode);
    }
}

