/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.lib.commons.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;

public class HexInputStream
extends InputStream {
    private final StringReader reader;

    public HexInputStream(StringReader stringReader) {
        this.reader = stringReader;
    }

    public int read() throws IOException {
        int n = this.reader.read();
        if (n == -1) {
            return n;
        }
        int n2 = this.getHexCode(n);
        n = this.reader.read();
        if (n == -1) {
            throw new IOException("Incomplete data sequence");
        }
        return (n2 << 4) + this.getHexCode(n);
    }

    private int getHexCode(int n) throws IOException {
        switch (n) {
            case 48: {
                return 0;
            }
            case 49: {
                return 1;
            }
            case 50: {
                return 2;
            }
            case 51: {
                return 3;
            }
            case 52: {
                return 4;
            }
            case 53: {
                return 5;
            }
            case 54: {
                return 6;
            }
            case 55: {
                return 7;
            }
            case 56: {
                return 8;
            }
            case 57: {
                return 9;
            }
            case 97: {
                return 10;
            }
            case 98: {
                return 11;
            }
            case 99: {
                return 12;
            }
            case 100: {
                return 13;
            }
            case 101: {
                return 14;
            }
            case 102: {
                return 15;
            }
        }
        throw new IOException("Char must be from '0' to '9' or 'a' to 'f'");
    }
}

