/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.lib.commons.datasource.valuecomparable;

import java.math.BigDecimal;
import java.text.NumberFormat;
import pl.com.stream.lib.commons.datasource.valuecomparable.ValueComparable;

public class BigDecimalComparable
implements ValueComparable {
    private static final long serialVersionUID = 9221615345106242427L;
    private final BigDecimal value;

    public BigDecimalComparable(double d) {
        this(new BigDecimal(d));
    }

    public BigDecimalComparable(BigDecimal bigDecimal) {
        this.value = bigDecimal;
    }

    public int compareTo(Object object) throws ClassCastException {
        return this.value.compareTo((BigDecimal)object);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        BigDecimalComparable bigDecimalComparable = (BigDecimalComparable)object;
        return !(this.value == null ? bigDecimalComparable.value != null : !this.value.equals(bigDecimalComparable.value));
    }

    public String getValueAsString() {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMinimumFractionDigits(0);
        numberFormat.setMaximumFractionDigits(4);
        return numberFormat.format(this.value.doubleValue());
    }

    public Object getValue() {
        return this.value;
    }
}

