/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.lib.commons.datasource.pojo;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.util.Calendar;
import java.util.HashMap;
import org.apache.log4j.Logger;
import pl.com.stream.lib.commons.datasource.dataset.field.ArrayValuesProvider;
import pl.com.stream.lib.commons.datasource.dataset.field.EnumValuesProvider;
import pl.com.stream.lib.commons.datasource.dataset.field.ValuesProvider;
import pl.com.stream.lib.commons.datasource.dataset.field.def.FieldDataType;
import pl.com.stream.lib.commons.datasource.pojo.DataSet;
import pl.com.stream.lib.commons.datasource.pojo.Field;
import pl.com.stream.lib.commons.datasource.pojo.FieldType;
import pl.com.stream.lib.commons.datasource.pojo.FieldValues;
import pl.com.stream.lib.commons.datasource.pojo.FieldValuesProvider;
import pl.com.stream.lib.commons.datasource.pojo.PojoDataSet;
import pl.com.stream.lib.commons.datasource.pojo.PojoDataSetDef;
import pl.com.stream.lib.commons.datasource.pojo.PojoFieldDef;
import pl.com.stream.lib.commons.datasource.pojo.PojoFieldImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PojoParser {
    private static final Logger logger = Logger.getLogger(PojoParser.class);
    static HashMap<Class<?>, FieldDataType> map = new HashMap();

    PojoParser() {
    }

    public static PojoDataSet parse(Object object) {
        java.lang.reflect.Field[] fieldArray;
        if (!object.getClass().isAnnotationPresent(DataSet.class)) {
            logger.warn("Class " + object.getClass().getName() + " require an " + DataSet.class.getName() + " annotation ");
            return null;
        }
        DataSet dataSet = object.getClass().getAnnotation(DataSet.class);
        PojoDataSet pojoDataSet = new PojoDataSet(dataSet.name(), object);
        PojoDataSetDef pojoDataSetDef = PojoParser.parseClass(object.getClass());
        for (java.lang.reflect.Field field : fieldArray = object.getClass().getDeclaredFields()) {
            String string;
            if (!field.isAnnotationPresent(Field.class)) continue;
            Field field2 = field.getAnnotation(Field.class);
            String string2 = field2.name();
            if (string2.length() == 0) {
                string2 = field.getName();
            }
            if ((string = field2.label()).length() == 0) {
                string = string2;
            }
            PojoFieldDef pojoFieldDef = (PojoFieldDef)pojoDataSetDef.getFieldDef(string2);
            pojoDataSetDef.addFieldDef(pojoFieldDef);
            PojoFieldImpl pojoFieldImpl = new PojoFieldImpl(pojoFieldDef, field, string2);
            pojoFieldImpl.setRequired(field2.required());
            pojoFieldImpl.setEditable(field2.editable());
            pojoFieldImpl.setEnabled(field2.enabled());
            pojoFieldImpl.setUnique(field2.unique());
            pojoFieldImpl.setVisible(field2.visible());
            pojoFieldImpl.setSupportPressReturn(field2.supportPressReturn());
            ValuesProvider valuesProvider = PojoParser.createValuesProvider(field);
            pojoFieldImpl.setAcceptableValuesProvider(valuesProvider);
            pojoDataSet.addField(pojoFieldImpl);
            pojoDataSet.addDataSetDef(pojoDataSetDef);
        }
        return pojoDataSet;
    }

    public static PojoDataSetDef parseClass(Class<?> clazz) {
        java.lang.reflect.Field[] fieldArray;
        if (!clazz.isAnnotationPresent(DataSet.class)) {
            logger.warn("Class " + clazz.getName() + " require an " + DataSet.class.getName() + " annotation ");
            return null;
        }
        DataSet dataSet = clazz.getAnnotation(DataSet.class);
        PojoDataSetDef pojoDataSetDef = new PojoDataSetDef(dataSet.name());
        for (java.lang.reflect.Field field : fieldArray = clazz.getDeclaredFields()) {
            String string;
            if (!field.isAnnotationPresent(Field.class)) continue;
            Field field2 = field.getAnnotation(Field.class);
            String string2 = field2.name();
            if (string2.length() == 0) {
                string2 = field.getName();
            }
            if ((string = field2.label()).length() == 0) {
                string = string2;
            }
            FieldDataType fieldDataType = PojoParser.getFieldDataType(field);
            String string3 = field2.domainName().length() == 0 ? null : field2.domainName();
            PojoFieldDef pojoFieldDef = new PojoFieldDef(string2, field2.description(), string3, string, field2.length(), fieldDataType);
            pojoDataSetDef.addFieldDef(pojoFieldDef);
        }
        return pojoDataSetDef;
    }

    private static FieldDataType getFieldDataType(java.lang.reflect.Field field) {
        if (field.isAnnotationPresent(FieldType.class)) {
            FieldType fieldType = field.getAnnotation(FieldType.class);
            return fieldType.type();
        }
        FieldDataType fieldDataType = map.get(field.getType());
        if (fieldDataType != null) {
            return fieldDataType;
        }
        return FieldDataType.STRING;
    }

    private static ValuesProvider createValuesProvider(java.lang.reflect.Field field) {
        Class<?> clazz = field.getType();
        try {
            if (field.isAnnotationPresent(FieldValuesProvider.class)) {
                FieldValuesProvider fieldValuesProvider = field.getAnnotation(FieldValuesProvider.class);
                Class<? extends ValuesProvider> clazz2 = fieldValuesProvider.providerClass();
                return clazz2.newInstance();
            }
            if (Enum.class.isAssignableFrom(clazz)) {
                return new EnumValuesProvider((Enum[])clazz.getEnumConstants());
            }
            if (field.isAnnotationPresent(FieldValues.class)) {
                if (String.class.isAssignableFrom(clazz)) {
                    FieldValues fieldValues = field.getAnnotation(FieldValues.class);
                    Object[] objectArray = fieldValues.values();
                    return new ArrayValuesProvider(objectArray);
                }
                logger.warn("Only String fields can be annotiated with " + FieldValues.class.getName() + " annotation.");
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.warn("Can not create values provider instance: " + clazz.getName(), illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            logger.warn("Can not create values provider instance: " + clazz.getName(), instantiationException);
        }
        return null;
    }

    static {
        map.put(Boolean.TYPE, FieldDataType.BOOLEAN);
        map.put(Boolean.class, FieldDataType.BOOLEAN);
        map.put(Date.class, FieldDataType.DATE);
        map.put(java.util.Date.class, FieldDataType.DATE);
        map.put(Time.class, FieldDataType.TIME);
        map.put(Calendar.class, FieldDataType.DATETIME);
        map.put(Long.TYPE, FieldDataType.LONG);
        map.put(Long.class, FieldDataType.LONG);
        map.put(Double.TYPE, FieldDataType.NUMERIC);
        map.put(Double.class, FieldDataType.NUMERIC);
        map.put(Float.TYPE, FieldDataType.NUMERIC);
        map.put(Float.class, FieldDataType.NUMERIC);
        map.put(BigDecimal.class, FieldDataType.NUMERIC);
        map.put(Integer.TYPE, FieldDataType.INTEGER);
        map.put(Integer.class, FieldDataType.INTEGER);
        map.put(BigInteger.class, FieldDataType.INTEGER);
        map.put(Short.TYPE, FieldDataType.INTEGER);
        map.put(Short.class, FieldDataType.INTEGER);
        map.put(Byte.TYPE, FieldDataType.INTEGER);
        map.put(Byte.class, FieldDataType.INTEGER);
    }
}

