/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.lib.commons.datasource.pojo;

import java.lang.reflect.Field;
import java.util.List;
import org.apache.log4j.Logger;
import pl.com.stream.lib.commons.datasource.dataset.field.AbstractField;
import pl.com.stream.lib.commons.datasource.dataset.field.def.FieldDef;
import pl.com.stream.lib.commons.datasource.dataset.validation.ValidationInfo;
import pl.com.stream.lib.commons.datasource.dataset.validation.ValidationResult;
import pl.com.stream.lib.commons.datasource.dataset.validation.ValidationStatus;
import pl.com.stream.lib.commons.datasource.dataset.validation.impl.ValidationInfoFactory;
import pl.com.stream.lib.commons.datasource.dataset.validation.impl.ValidationInfoImpl;
import pl.com.stream.lib.commons.datasource.dataset.validation.impl.ValidationResultImpl;
import pl.com.stream.lib.commons.datasource.pojo.PojoField;
import pl.com.stream.lib.commons.datasource.pojo.PojoFieldDef;

class PojoFieldImpl
extends AbstractField
implements PojoField {
    static final Logger logger = Logger.getLogger(PojoFieldImpl.class);
    private Object value;
    private final Field field;
    private final PojoFieldDef pojoFieldDef;
    private final ValidationResultImpl validationResult;

    PojoFieldImpl(PojoFieldDef pojoFieldDef, Field field, String string) {
        super(string);
        this.pojoFieldDef = pojoFieldDef;
        this.field = field;
        try {
            field.setAccessible(true);
        }
        catch (SecurityException securityException) {
            logger.warn(securityException);
        }
        this.validationResult = new ValidationResultImpl();
    }

    public FieldDef getDef() {
        return this.pojoFieldDef;
    }

    public Field getField() {
        return this.field;
    }

    public ValidationResult getValidationResult() {
        return this.validationResult;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object object) {
        if (this.hasChanged(this.value, object)) {
            this.value = object;
            logger.debug("Value of field: " + this.getName() + " has changed.");
            this.fireValueChanged();
        }
    }

    public ValidationStatus verify() {
        List<ValidationInfo> list = this.validationResult.getValidationsInfo();
        list.clear();
        if (this.isRequired()) {
            ValidationInfoImpl validationInfoImpl = ValidationInfoFactory.createRequiredValidationInfo(this.getName());
            validationInfoImpl.setValidationStatus(this.value == null ? ValidationStatus.VALIDATION_ERROR : ValidationStatus.VALIDATION_OK);
            list.add(validationInfoImpl);
        }
        this.validationResult.verifyValidationStatus();
        this.fireAfterValidationStatusChanged();
        return this.validationResult.getValidationStatus();
    }
}

