/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.lib.commons.datasource.pojo;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import pl.com.stream.lib.commons.datasource.DataSource;
import pl.com.stream.lib.commons.datasource.MetaDataSource;
import pl.com.stream.lib.commons.datasource.dataset.DataSet;
import pl.com.stream.lib.commons.datasource.dataset.def.DataSetDef;
import pl.com.stream.lib.commons.datasource.dataset.field.def.FieldDef;
import pl.com.stream.lib.commons.datasource.dataset.flag.Flag;
import pl.com.stream.lib.commons.datasource.dataset.validation.ValidationStatus;
import pl.com.stream.lib.commons.datasource.pojo.PojoDataSet;
import pl.com.stream.lib.commons.datasource.pojo.PojoDataSetDef;
import pl.com.stream.lib.commons.datasource.pojo.PojoField;
import pl.com.stream.lib.commons.datasource.pojo.PojoFieldImpl;
import pl.com.stream.lib.commons.datasource.pojo.PojoFlag;
import pl.com.stream.lib.commons.datasource.pojo.PojoParser;
import pl.com.stream.lib.commons.util.OrderMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PojoDataSource
implements DataSource,
MetaDataSource {
    private static final Logger logger = Logger.getLogger(PojoDataSource.class);
    private final boolean autoUpdatePojo;
    private Map<String, PojoDataSetDef> dataSetDefMap = new HashMap<String, PojoDataSetDef>();
    private OrderMap<String, PojoDataSet> dataSetMap = new OrderMap();

    public PojoDataSource() {
        this.autoUpdatePojo = true;
    }

    public PojoDataSource(boolean bl) {
        this.autoUpdatePojo = bl;
    }

    public PojoField getPojoField(String string, String string2) {
        DataSet dataSet = this.getDataSet(string);
        PojoField pojoField = dataSet != null ? (PojoField)dataSet.getField(string2) : null;
        return pojoField;
    }

    public void addPojo(Object object) {
        PojoDataSet pojoDataSet = PojoParser.parse(object);
        if (pojoDataSet != null) {
            this.addDataSet(pojoDataSet);
            pojoDataSet.setAutoUpdatePojo(this.autoUpdatePojo);
            this.addDataSetDef(pojoDataSet.getDefaultDataSetDef());
            this.updateFieldsValues();
        } else {
            logger.warn("Class " + object.getClass().getName() + " require an " + DataSet.class.getName() + " annotation ");
        }
    }

    @Override
    public DataSet getDataSet(String string) {
        return (DataSet)this.getDataSetMap().get(string);
    }

    @Override
    public DataSetDef getDataSetDef(String string) {
        return this.getDataSetDefMap().get(string);
    }

    @Override
    public Collection<? extends DataSet> getDataSets() {
        return this.getDataSetMap().getValueList();
    }

    @Override
    public FieldDef getFieldDef(String string, String string2) {
        DataSetDef dataSetDef = this.getDataSetDef(string);
        if (dataSetDef != null) {
            List<? extends FieldDef> list = dataSetDef.getFieldDefList();
            for (FieldDef fieldDef : list) {
                if (!fieldDef.getName().equals(string2)) continue;
                return fieldDef;
            }
        }
        return null;
    }

    public Flag getFlag(String string, String string2) {
        PojoDataSet pojoDataSet = (PojoDataSet)this.getDataSetMap().get(string);
        if (pojoDataSet == null) {
            logger.warn("DataSet " + string + " not exist");
            return null;
        }
        Flag flag = pojoDataSet.getFlag(string2);
        if (flag == null) {
            logger.warn("Plag " + string2 + " in DataSet " + string + " not exist");
            return null;
        }
        return pojoDataSet.getDefaultFlag(string2);
    }

    public Flag initFlag(String string, String string2, Object object) {
        PojoDataSet pojoDataSet = (PojoDataSet)this.getDataSetMap().get(string);
        if (pojoDataSet == null) {
            logger.warn("DataSet " + string + " not exist");
            return null;
        }
        Flag flag = pojoDataSet.getFlag(string2);
        if (flag == null) {
            flag = new PojoFlag(object);
            pojoDataSet.addFlag(string2, (PojoFlag)flag);
        } else {
            pojoDataSet.getDefaultFlag(string2).setValue(object);
        }
        return flag;
    }

    public void updateFieldsValues() {
        Set set = this.getDataSetMap().keySet();
        for (String string : set) {
            PojoDataSet pojoDataSet = (PojoDataSet)this.getDataSetMap().get(string);
            pojoDataSet.updateFieldsValues();
        }
    }

    public void updatePojoValues() {
        Set set = this.getDataSetMap().keySet();
        for (String string : set) {
            PojoDataSet pojoDataSet = (PojoDataSet)this.getDataSetMap().get(string);
            pojoDataSet.updatePojoValues();
        }
    }

    public ValidationStatus verify() {
        ValidationStatus validationStatus = ValidationStatus.VALIDATION_OK;
        for (PojoDataSet pojoDataSet : this.getDataSetMap().getValueList()) {
            for (PojoField pojoField : pojoDataSet.getFields()) {
                ValidationStatus validationStatus2 = ((PojoFieldImpl)pojoField).verify();
                if (validationStatus2.getPriority() <= validationStatus.getPriority()) continue;
                validationStatus = validationStatus2;
            }
        }
        return validationStatus;
    }

    protected void addDataSet(PojoDataSet pojoDataSet) {
        this.getDataSetMap().put(pojoDataSet.getName(), pojoDataSet);
    }

    protected void addDataSetDef(PojoDataSetDef pojoDataSetDef) {
        this.getDataSetDefMap().put(pojoDataSetDef.getName(), pojoDataSetDef);
    }

    protected Map<String, PojoDataSetDef> getDataSetDefMap() {
        if (this.dataSetDefMap == null) {
            this.dataSetDefMap = new HashMap<String, PojoDataSetDef>();
        }
        return this.dataSetDefMap;
    }

    protected OrderMap<String, PojoDataSet> getDataSetMap() {
        if (this.dataSetMap == null) {
            this.dataSetMap = new OrderMap();
        }
        return this.dataSetMap;
    }
}

