/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.lib.commons.datasource.pojo;

import java.util.Collection;
import java.util.List;
import javax.swing.event.EventListenerList;
import org.apache.log4j.Logger;
import pl.com.stream.lib.commons.datasource.dataset.DataSet;
import pl.com.stream.lib.commons.datasource.dataset.DataSetEvent;
import pl.com.stream.lib.commons.datasource.dataset.DataSetListener;
import pl.com.stream.lib.commons.datasource.dataset.field.Field;
import pl.com.stream.lib.commons.datasource.dataset.field.FieldEvent;
import pl.com.stream.lib.commons.datasource.dataset.field.FieldEventAdapter;
import pl.com.stream.lib.commons.datasource.dataset.field.PropertyAdapter;
import pl.com.stream.lib.commons.datasource.dataset.flag.Flag;
import pl.com.stream.lib.commons.datasource.dataset.validation.ValidationResult;
import pl.com.stream.lib.commons.datasource.dataset.validation.impl.ValidationResultImpl;
import pl.com.stream.lib.commons.datasource.pojo.PojoDataSetDef;
import pl.com.stream.lib.commons.datasource.pojo.PojoField;
import pl.com.stream.lib.commons.datasource.pojo.PojoFieldImpl;
import pl.com.stream.lib.commons.datasource.pojo.PojoFlag;
import pl.com.stream.lib.commons.util.OrderMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PojoDataSet
implements DataSet {
    private static final Logger logger = Logger.getLogger(PojoDataSet.class);
    private boolean autoUpdatePojo = true;
    private final Object pojo;
    private boolean editable = true;
    private final OrderMap<String, PojoFieldImpl> fieldMap;
    private final OrderMap<String, PojoFlag> flagMap;
    private final EventListenerList listenerList;
    private final String name;
    private PojoDataSetDef pojoDataSetDef;
    private final ValidationResultImpl validationResult = new ValidationResultImpl();

    public PojoDataSet(String string, Object object) {
        this.name = string;
        this.pojo = object;
        this.fieldMap = new OrderMap();
        this.flagMap = new OrderMap();
        this.listenerList = new EventListenerList();
    }

    public void addDataSetDef(PojoDataSetDef pojoDataSetDef) {
        this.setDefaultDataSetDef(pojoDataSetDef);
    }

    @Override
    public void addDataSetListener(DataSetListener dataSetListener) {
        this.listenerList.add(DataSetListener.class, dataSetListener);
    }

    void addField(PojoFieldImpl pojoFieldImpl) {
        this.fieldMap.put(pojoFieldImpl.getName(), pojoFieldImpl);
        pojoFieldImpl.setEditableDataSet(this.editable);
        pojoFieldImpl.addEventListener(new FieldEventAdapter(){

            public void activated(FieldEvent fieldEvent) {
                PojoDataSet.this.fireFieldActivated(fieldEvent.getField());
            }

            public void deactivated(FieldEvent fieldEvent) {
                PojoDataSet.this.fireFieldDeactivated(fieldEvent.getField());
            }

            public void valueModifying(FieldEvent fieldEvent) {
                PojoDataSet.this.fireFieldModified(fieldEvent.getField());
            }
        });
        pojoFieldImpl.addPropertyListener(new PropertyAdapter(){

            public void valueChanged(FieldEvent fieldEvent) {
                if (PojoDataSet.this.isAutoUpdatePojo()) {
                    PojoDataSet.this.updateValuePojo((PojoField)fieldEvent.getField());
                }
                PojoDataSet.this.fireFieldChanged(fieldEvent.getField());
            }

            public void afterValidationStatusChanged(FieldEvent fieldEvent) {
                PojoDataSet.this.fireValidationResultChanged(fieldEvent.getField());
            }
        });
    }

    public void addFlag(String string, PojoFlag pojoFlag) {
        this.flagMap.put(string, pojoFlag);
    }

    public PojoDataSetDef getDefaultDataSetDef() {
        return this.pojoDataSetDef;
    }

    public PojoFlag getDefaultFlag(String string) {
        return (PojoFlag)this.flagMap.get(string);
    }

    @Override
    public Field getField(String string) {
        return (Field)this.fieldMap.get(string);
    }

    public Collection<? extends PojoField> getFields() {
        return this.fieldMap.getValueList();
    }

    @Override
    public Flag getFlag(String string) {
        return (Flag)this.flagMap.get(string);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ValidationResult getValidationStatus() {
        return this.validationResult;
    }

    public boolean isAutoUpdatePojo() {
        return this.autoUpdatePojo;
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    @Override
    public void removeDataSetListener(DataSetListener dataSetListener) {
        this.listenerList.remove(DataSetListener.class, dataSetListener);
    }

    public void setAutoUpdatePojo(boolean bl) {
        this.autoUpdatePojo = bl;
    }

    public void setDefaultDataSetDef(PojoDataSetDef pojoDataSetDef) {
        this.pojoDataSetDef = pojoDataSetDef;
    }

    @Override
    public void setEditable(boolean bl) {
        if (this.editable != bl) {
            this.editable = bl;
            this.updateEditableFieldProperty();
        }
    }

    public void updatePojoValues() {
        Collection<? extends PojoField> collection = this.getFields();
        for (PojoField pojoField : collection) {
            this.updateValuePojo(pojoField);
        }
    }

    public void updateFieldsValues() {
        Collection<? extends PojoField> collection = this.getFields();
        for (PojoField pojoField : collection) {
            try {
                Object object = ((PojoFieldImpl)pojoField).getField().get(this.pojo);
                pojoField.setValue(object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                logger.warn(illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                logger.warn(illegalAccessException);
            }
        }
    }

    private void fireFieldActivated(Field field) {
        DataSetListener[] dataSetListenerArray = (DataSetListener[])this.listenerList.getListeners(DataSetListener.class);
        DataSetEvent dataSetEvent = new DataSetEvent(this, field);
        for (DataSetListener dataSetListener : dataSetListenerArray) {
            dataSetListener.fieldActivated(dataSetEvent);
        }
    }

    private void fireFieldChanged(Field field) {
        DataSetListener[] dataSetListenerArray = (DataSetListener[])this.listenerList.getListeners(DataSetListener.class);
        DataSetEvent dataSetEvent = new DataSetEvent(this, field);
        for (DataSetListener dataSetListener : dataSetListenerArray) {
            dataSetListener.fieldChanged(dataSetEvent);
        }
    }

    private void fireFieldDeactivated(Field field) {
        DataSetListener[] dataSetListenerArray = (DataSetListener[])this.listenerList.getListeners(DataSetListener.class);
        DataSetEvent dataSetEvent = new DataSetEvent(this, field);
        for (DataSetListener dataSetListener : dataSetListenerArray) {
            dataSetListener.fieldDeactivated(dataSetEvent);
        }
    }

    private void fireValidationResultChanged(Field field) {
        DataSetListener[] dataSetListenerArray = (DataSetListener[])this.listenerList.getListeners(DataSetListener.class);
        DataSetEvent dataSetEvent = new DataSetEvent(this, field);
        for (DataSetListener dataSetListener : dataSetListenerArray) {
            dataSetListener.validationResultChanged(dataSetEvent);
        }
    }

    private void fireFieldModified(Field field) {
        DataSetListener[] dataSetListenerArray = (DataSetListener[])this.listenerList.getListeners(DataSetListener.class);
        DataSetEvent dataSetEvent = new DataSetEvent(this, field);
        for (DataSetListener dataSetListener : dataSetListenerArray) {
            dataSetListener.fieldModified(dataSetEvent);
        }
    }

    private void updateEditableFieldProperty() {
        List<PojoFieldImpl> list = this.fieldMap.getValueList();
        for (PojoField pojoField : list) {
            ((PojoFieldImpl)pojoField).setEditableDataSet(this.editable);
        }
    }

    private void updateValuePojo(PojoField pojoField) {
        try {
            ((PojoFieldImpl)pojoField).getField().set(this.pojo, pojoField.getValue());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.warn(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.warn(illegalAccessException);
        }
    }
}

