/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.lib.commons.datasource.dataset.validation.impl;

import java.util.ArrayList;
import java.util.List;
import pl.com.stream.lib.commons.datasource.dataset.validation.ValidationInfo;
import pl.com.stream.lib.commons.datasource.dataset.validation.ValidationResult;
import pl.com.stream.lib.commons.datasource.dataset.validation.ValidationStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationResultImpl
implements ValidationResult {
    private static final long serialVersionUID = -6204311456362003134L;
    private final ArrayList<ValidationInfo> list = new ArrayList();
    private ValidationStatus validationStatus = ValidationStatus.NO_VALIDATION;

    public void add(ValidationInfo validationInfo) {
        this.list.add(validationInfo);
    }

    public void addAll(List<ValidationInfo> list) {
        this.list.addAll(list);
    }

    public void clear() {
        this.list.clear();
        this.setStatusNoValidation();
        this.fireChanged();
    }

    @Override
    public List<ValidationInfo> getValidationsInfo() {
        return this.list;
    }

    @Override
    public ValidationStatus getValidationStatus() {
        return this.validationStatus;
    }

    public void verifyValidationStatus() {
        ValidationStatus validationStatus = ValidationStatus.VALIDATION_OK;
        for (ValidationInfo validationInfo : this.list) {
            if (validationInfo.getValidationStatus().getPriority() <= validationStatus.getPriority()) continue;
            validationStatus = validationInfo.getValidationStatus();
        }
        this.setValidationStatus(validationStatus);
        this.fireChanged();
    }

    protected void fireChanged() {
    }

    private void setStatusNoValidation() {
        this.setValidationStatus(ValidationStatus.NO_VALIDATION);
    }

    private void setValidationStatus(ValidationStatus validationStatus) {
        if (!this.validationStatus.equals(validationStatus)) {
            this.validationStatus = validationStatus;
        }
    }
}

