/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.lib.commons.datasource.dataset.field.action;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.EventListenerList;
import pl.com.stream.lib.commons.datasource.dataset.field.action.ActionItem;
import pl.com.stream.lib.commons.datasource.dataset.field.action.ActionItemEvent;
import pl.com.stream.lib.commons.datasource.dataset.field.action.ActionItemProvider;
import pl.com.stream.lib.commons.datasource.dataset.field.action.ActionItemProviderEvent;
import pl.com.stream.lib.commons.datasource.dataset.field.action.ActionItemProviderListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultActionItemProvider
implements ActionItemProvider {
    private List<ActionItem> actionList;
    private EventListenerList listenerList;

    public void addActionItem(ActionItem actionItem) {
        this.getActionItemList().add(actionItem);
        this.fireActionItemAdded(actionItem);
    }

    @Override
    public void addActionItemProviderListener(ActionItemProviderListener actionItemProviderListener) {
        this.getListenerList().add(ActionItemProviderListener.class, actionItemProviderListener);
    }

    @Override
    public List<ActionItem> getActionItemList() {
        if (this.actionList == null) {
            this.actionList = new ArrayList<ActionItem>();
        }
        return this.actionList;
    }

    public void removeActionItem(ActionItem actionItem) {
        this.getActionItemList().remove(actionItem);
        this.fireActionItemRemoved(actionItem);
    }

    @Override
    public void removeActionItemProviderListener(ActionItemProviderListener actionItemProviderListener) {
        this.getListenerList().remove(ActionItemProviderListener.class, actionItemProviderListener);
    }

    protected void fireActionItemAdded(ActionItem actionItem) {
        ActionItemProviderListener[] actionItemProviderListenerArray = (ActionItemProviderListener[])this.getListenerList().getListeners(ActionItemProviderListener.class);
        ActionItemEvent actionItemEvent = new ActionItemEvent(actionItem);
        for (ActionItemProviderListener actionItemProviderListener : actionItemProviderListenerArray) {
            actionItemProviderListener.actionAdded(actionItemEvent);
        }
    }

    protected void fireActionItemProviderChanged() {
        ActionItemProviderListener[] actionItemProviderListenerArray = (ActionItemProviderListener[])this.getListenerList().getListeners(ActionItemProviderListener.class);
        ActionItemProviderEvent actionItemProviderEvent = new ActionItemProviderEvent(this);
        for (ActionItemProviderListener actionItemProviderListener : actionItemProviderListenerArray) {
            actionItemProviderListener.actionProviderChanged(actionItemProviderEvent);
        }
    }

    protected void fireActionItemRemoved(ActionItem actionItem) {
        ActionItemProviderListener[] actionItemProviderListenerArray = (ActionItemProviderListener[])this.getListenerList().getListeners(ActionItemProviderListener.class);
        ActionItemEvent actionItemEvent = new ActionItemEvent(actionItem);
        for (ActionItemProviderListener actionItemProviderListener : actionItemProviderListenerArray) {
            actionItemProviderListener.actionRemoved(actionItemEvent);
        }
    }

    protected EventListenerList getListenerList() {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        return this.listenerList;
    }
}

