/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.lib.commons.datasource.dataset.field.action;

import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import javax.swing.event.EventListenerList;
import pl.com.stream.lib.commons.datasource.dataset.field.action.Action;
import pl.com.stream.lib.commons.datasource.dataset.field.action.ActionEvent;
import pl.com.stream.lib.commons.datasource.dataset.field.action.ActionListener;

public abstract class AbstractAction
implements Action,
Serializable {
    private static final long serialVersionUID = 660561861568931072L;
    private boolean autoCommitValue = true;
    private boolean enabled = true;
    private Icon icon;
    private KeyStroke keyStroke;
    private EventListenerList listenerList;
    private String text;

    public void addActionListener(ActionListener actionListener) {
        this.getListenerList().add(ActionListener.class, actionListener);
    }

    public Icon getIcon() {
        return this.icon;
    }

    public KeyStroke getKeyStroke() {
        return this.keyStroke;
    }

    public String getText() {
        return this.text;
    }

    public boolean isAutoCommitValue() {
        return this.autoCommitValue;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void removeActionListener(ActionListener actionListener) {
        this.getListenerList().remove(ActionListener.class, actionListener);
    }

    public void setAutoCommitValue(boolean bl) {
        if (this.autoCommitValue != bl) {
            this.autoCommitValue = bl;
            this.fireOnAutoCommitValueChanged();
        }
    }

    public void setEnabled(boolean bl) {
        if (this.enabled != bl) {
            this.enabled = bl;
            this.fireOnEnabledChanged();
        }
    }

    public void setIcon(Icon icon) {
        if (this.hasValueChanged(this.icon, icon)) {
            this.icon = icon;
            this.fireOnIconChanged();
        }
    }

    public void setKeyStroke(KeyStroke keyStroke) {
        if (this.hasValueChanged(this.keyStroke, keyStroke)) {
            this.keyStroke = keyStroke;
            this.fireOnKeyStrokeChanged();
        }
    }

    public void setText(String string) {
        if (this.hasValueChanged(this.text, string)) {
            this.text = string;
            this.fireOnTextChanged();
        }
    }

    private boolean hasValueChanged(Object object, Object object2) {
        return (object == null || object2 == null || !object.equals(object2)) && (object != null || object2 != null);
    }

    protected void fireOnAutoCommitValueChanged() {
        ActionListener[] actionListenerArray = (ActionListener[])this.getListenerList().getListeners(ActionListener.class);
        ActionEvent actionEvent = new ActionEvent(this);
        for (ActionListener actionListener : actionListenerArray) {
            actionListener.autoCommitValuePropertyChanged(actionEvent);
        }
    }

    protected void fireOnEnabledChanged() {
        ActionListener[] actionListenerArray = (ActionListener[])this.getListenerList().getListeners(ActionListener.class);
        ActionEvent actionEvent = new ActionEvent(this);
        for (ActionListener actionListener : actionListenerArray) {
            actionListener.enabledPropertyChanged(actionEvent);
        }
    }

    protected void fireOnIconChanged() {
        ActionListener[] actionListenerArray = (ActionListener[])this.getListenerList().getListeners(ActionListener.class);
        ActionEvent actionEvent = new ActionEvent(this);
        for (ActionListener actionListener : actionListenerArray) {
            actionListener.iconPropertyChanged(actionEvent);
        }
    }

    protected void fireOnKeyStrokeChanged() {
        ActionListener[] actionListenerArray = (ActionListener[])this.getListenerList().getListeners(ActionListener.class);
        ActionEvent actionEvent = new ActionEvent(this);
        for (ActionListener actionListener : actionListenerArray) {
            actionListener.keyStrokePropertyChanged(actionEvent);
        }
    }

    protected void fireOnTextChanged() {
        ActionListener[] actionListenerArray = (ActionListener[])this.getListenerList().getListeners(ActionListener.class);
        ActionEvent actionEvent = new ActionEvent(this);
        for (ActionListener actionListener : actionListenerArray) {
            actionListener.textPropertyChanged(actionEvent);
        }
    }

    protected EventListenerList getListenerList() {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        return this.listenerList;
    }
}

