/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.lib.commons.datasource.dataset.field;

import javax.swing.event.EventListenerList;
import org.apache.log4j.Logger;
import pl.com.stream.lib.commons.datasource.dataset.field.Field;
import pl.com.stream.lib.commons.datasource.dataset.field.FieldEvent;
import pl.com.stream.lib.commons.datasource.dataset.field.FieldEventListener;
import pl.com.stream.lib.commons.datasource.dataset.field.PropertyListener;
import pl.com.stream.lib.commons.datasource.dataset.field.ValuesProvider;
import pl.com.stream.lib.commons.datasource.dataset.field.action.ActionItemProvider;
import pl.com.stream.lib.commons.datasource.valuecomparable.ValueComparable;

public abstract class AbstractField
implements Field {
    static final Logger logger = Logger.getLogger(AbstractField.class);
    private ValuesProvider acceptableValuesProvider;
    private ActionItemProvider actionProvider;
    private boolean editable;
    private boolean editableDataSet = true;
    private boolean enabled;
    private final String fieldName;
    private final EventListenerList listenerList = new EventListenerList();
    private ValueComparable maxValue;
    private ValueComparable minValue;
    private Integer precision;
    private boolean required;
    private boolean supportPressReturn;
    private boolean unique;
    private boolean visible;

    public AbstractField(String string) {
        this.fieldName = string;
    }

    public final void addEventListener(FieldEventListener fieldEventListener) {
        this.listenerList.add(FieldEventListener.class, fieldEventListener);
    }

    public final void addPropertyListener(PropertyListener propertyListener) {
        this.listenerList.add(PropertyListener.class, propertyListener);
    }

    public ValuesProvider getAcceptableValuesProvider() {
        return this.acceptableValuesProvider;
    }

    public ActionItemProvider getActionProvider() {
        return this.actionProvider;
    }

    public final ValueComparable getMaxValue() {
        return this.maxValue;
    }

    public final ValueComparable getMinValue() {
        return this.minValue;
    }

    public final String getName() {
        return this.fieldName;
    }

    public Integer getPrecision() {
        return this.precision;
    }

    public final boolean isEditable() {
        return this.editable && this.editableDataSet;
    }

    public boolean isEditableDataSet() {
        return this.editableDataSet;
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public final boolean isRequired() {
        return this.required;
    }

    public final boolean isSupportPressReturn() {
        return this.supportPressReturn;
    }

    public final boolean isUnique() {
        return this.unique;
    }

    public final boolean isVisible() {
        return this.visible;
    }

    public final void notifyActivation() {
        logger.debug("Value of field: " + this.fieldName + " has activated.");
        this.fireOnActivated();
    }

    public final void notifyDeactivation() {
        logger.debug("Value of field: " + this.fieldName + " has deactivated.");
        this.fireOnDeactivated();
    }

    public final void notifyPressReturn() {
        if (this.supportPressReturn) {
            this.firePressReturn();
        }
    }

    public final void notifyValueModification() {
        logger.debug("Value of field: " + this.fieldName + " has modified.");
        this.fireOnValueModified();
    }

    public final void removeEventListener(FieldEventListener fieldEventListener) {
        this.listenerList.remove(FieldEventListener.class, fieldEventListener);
    }

    public final void removePropertyListener(PropertyListener propertyListener) {
        this.listenerList.remove(PropertyListener.class, propertyListener);
    }

    public void requestActivation() {
        this.fireActivate();
    }

    public void setAcceptableValuesProvider(ValuesProvider valuesProvider) {
        if (this.hasChanged(this.acceptableValuesProvider, valuesProvider)) {
            this.acceptableValuesProvider = valuesProvider;
            Object object = this.getValue();
            this.setValue(null);
            this.fireAcceptableValuesProviderChanged();
            this.setValue(object);
        }
    }

    public void setActionProvider(ActionItemProvider actionItemProvider) {
        this.actionProvider = actionItemProvider;
    }

    public final void setEditable(boolean bl) {
        if (this.editable != bl) {
            this.editable = bl;
            this.fireAfterEditableChanged();
        }
    }

    public void setEditableDataSet(boolean bl) {
        if (this.editableDataSet != bl) {
            boolean bl2 = this.isEditable();
            this.editableDataSet = bl;
            if (bl2 != this.isEditable()) {
                this.fireAfterEditableChanged();
            }
        }
    }

    public final void setEnabled(boolean bl) {
        if (this.enabled != bl) {
            this.enabled = bl;
            this.fireAfterEnabledChanged();
        }
    }

    public final void setMaxValue(ValueComparable valueComparable) {
        if (this.hasChanged(this.maxValue, valueComparable)) {
            this.maxValue = valueComparable;
            this.fireAfterMaxValueChanged();
        }
    }

    public final void setMinValue(ValueComparable valueComparable) {
        if (this.hasChanged(this.minValue, valueComparable)) {
            this.minValue = valueComparable;
            this.fireAfterMinValueChanged();
        }
    }

    public void setPrecision(Integer n) {
        if (this.hasChanged(this.precision, n)) {
            this.precision = n;
            this.firePrecision();
        }
    }

    public void setRequired(boolean bl) {
        if (this.required != bl) {
            this.required = bl;
            this.fireAfterRequiredChanged();
        }
    }

    public final void setSupportPressReturn(boolean bl) {
        if (bl != this.supportPressReturn) {
            this.supportPressReturn = bl;
        }
    }

    public final void setUnique(boolean bl) {
        if (this.unique != bl) {
            this.unique = bl;
            this.fireAfterUniqueChanged();
        }
    }

    public final void setVisible(boolean bl) {
        if (this.visible != bl) {
            this.visible = bl;
            this.fireAfterVisibleChanged();
        }
    }

    private void fireActivate() {
        FieldEventListener[] fieldEventListenerArray = (FieldEventListener[])this.listenerList.getListeners(FieldEventListener.class);
        FieldEvent fieldEvent = new FieldEvent(this);
        for (FieldEventListener fieldEventListener : fieldEventListenerArray) {
            fieldEventListener.requestActivation(fieldEvent);
        }
    }

    private void fireAfterEditableChanged() {
        PropertyListener[] propertyListenerArray = (PropertyListener[])this.listenerList.getListeners(PropertyListener.class);
        FieldEvent fieldEvent = new FieldEvent(this);
        for (PropertyListener propertyListener : propertyListenerArray) {
            propertyListener.afterEditableChanged(fieldEvent);
        }
    }

    private void fireAfterEnabledChanged() {
        PropertyListener[] propertyListenerArray = (PropertyListener[])this.listenerList.getListeners(PropertyListener.class);
        FieldEvent fieldEvent = new FieldEvent(this);
        for (PropertyListener propertyListener : propertyListenerArray) {
            propertyListener.afterEnabledChanged(fieldEvent);
        }
    }

    private void fireAfterMaxValueChanged() {
        PropertyListener[] propertyListenerArray = (PropertyListener[])this.listenerList.getListeners(PropertyListener.class);
        FieldEvent fieldEvent = new FieldEvent(this);
        for (PropertyListener propertyListener : propertyListenerArray) {
            propertyListener.afterMaxValueChanged(fieldEvent);
        }
    }

    private void fireAfterMinValueChanged() {
        PropertyListener[] propertyListenerArray = (PropertyListener[])this.listenerList.getListeners(PropertyListener.class);
        FieldEvent fieldEvent = new FieldEvent(this);
        for (PropertyListener propertyListener : propertyListenerArray) {
            propertyListener.afterMinValueChanged(fieldEvent);
        }
    }

    private void fireAfterRequiredChanged() {
        PropertyListener[] propertyListenerArray = (PropertyListener[])this.listenerList.getListeners(PropertyListener.class);
        FieldEvent fieldEvent = new FieldEvent(this);
        for (PropertyListener propertyListener : propertyListenerArray) {
            propertyListener.afterRequiredChanged(fieldEvent);
        }
    }

    private void fireAfterUniqueChanged() {
        PropertyListener[] propertyListenerArray = (PropertyListener[])this.listenerList.getListeners(PropertyListener.class);
        FieldEvent fieldEvent = new FieldEvent(this);
        for (PropertyListener propertyListener : propertyListenerArray) {
            propertyListener.afterUniqueChanged(fieldEvent);
        }
    }

    private void fireAfterVisibleChanged() {
        PropertyListener[] propertyListenerArray = (PropertyListener[])this.listenerList.getListeners(PropertyListener.class);
        FieldEvent fieldEvent = new FieldEvent(this);
        for (PropertyListener propertyListener : propertyListenerArray) {
            propertyListener.afterVisibleChanged(fieldEvent);
        }
    }

    private void fireOnActivated() {
        FieldEventListener[] fieldEventListenerArray = (FieldEventListener[])this.listenerList.getListeners(FieldEventListener.class);
        FieldEvent fieldEvent = new FieldEvent(this);
        for (FieldEventListener fieldEventListener : fieldEventListenerArray) {
            fieldEventListener.activated(fieldEvent);
        }
    }

    private void fireOnDeactivated() {
        FieldEventListener[] fieldEventListenerArray = (FieldEventListener[])this.listenerList.getListeners(FieldEventListener.class);
        FieldEvent fieldEvent = new FieldEvent(this);
        for (FieldEventListener fieldEventListener : fieldEventListenerArray) {
            fieldEventListener.deactivated(fieldEvent);
        }
    }

    private void fireOnValueModified() {
        FieldEventListener[] fieldEventListenerArray = (FieldEventListener[])this.listenerList.getListeners(FieldEventListener.class);
        FieldEvent fieldEvent = new FieldEvent(this);
        for (FieldEventListener fieldEventListener : fieldEventListenerArray) {
            fieldEventListener.valueModifying(fieldEvent);
        }
    }

    private void firePrecision() {
        PropertyListener[] propertyListenerArray = (PropertyListener[])this.listenerList.getListeners(PropertyListener.class);
        FieldEvent fieldEvent = new FieldEvent(this);
        for (PropertyListener propertyListener : propertyListenerArray) {
            propertyListener.afterPrecisionChanged(fieldEvent);
        }
    }

    private void firePressReturn() {
        FieldEventListener[] fieldEventListenerArray = (FieldEventListener[])this.listenerList.getListeners(FieldEventListener.class);
        FieldEvent fieldEvent = new FieldEvent(this);
        for (FieldEventListener fieldEventListener : fieldEventListenerArray) {
            fieldEventListener.pressReturn(fieldEvent);
        }
    }

    protected final void fireAcceptableValuesProviderChanged() {
        PropertyListener[] propertyListenerArray = (PropertyListener[])this.listenerList.getListeners(PropertyListener.class);
        FieldEvent fieldEvent = new FieldEvent(this);
        for (PropertyListener propertyListener : propertyListenerArray) {
            propertyListener.acceptableValuesProviderChanged(fieldEvent);
        }
    }

    protected final void fireAfterValidationStatusChanged() {
        PropertyListener[] propertyListenerArray = (PropertyListener[])this.listenerList.getListeners(PropertyListener.class);
        FieldEvent fieldEvent = new FieldEvent(this);
        for (PropertyListener propertyListener : propertyListenerArray) {
            propertyListener.afterValidationStatusChanged(fieldEvent);
        }
    }

    protected final void fireValueChanged() {
        PropertyListener[] propertyListenerArray = (PropertyListener[])this.listenerList.getListeners(PropertyListener.class);
        FieldEvent fieldEvent = new FieldEvent(this);
        for (PropertyListener propertyListener : propertyListenerArray) {
            propertyListener.valueChanged(fieldEvent);
        }
    }

    protected final boolean hasChanged(Object object, Object object2) {
        return (object == null || object2 == null || !object.equals(object2)) && (object != null || object2 != null);
    }
}

