/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.lib.commons.datasource.binding;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pl.com.stream.lib.commons.datasource.MetaDataSource;
import pl.com.stream.lib.commons.datasource.binding.BindingKeyListProviderException;
import pl.com.stream.lib.commons.datasource.dataset.def.DataSetDef;
import pl.com.stream.lib.commons.datasource.dataset.field.def.FieldDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingKeyListProvider {
    public static final String BINDING_DEFAULT = "template";
    public static final String BINDING_FIELD = "field";
    public static final String BINDING_VIEW = "view";
    private Map<String, BindingParser> parserMap;

    public List<String> getKeyList(String string, MetaDataSource metaDataSource) {
        if (string == null) {
            return null;
        }
        BindingParser bindingParser = null;
        String[] stringArray = string.split("\\.");
        if (stringArray.length == 0) {
            throw new BindingKeyListProviderException("Unsupported binding format: " + string);
        }
        String string2 = stringArray[0];
        bindingParser = this.getParserMap().get(string2);
        if (bindingParser != null) {
            string = string.replace(string2 + ".", "");
        }
        if (bindingParser == null) {
            bindingParser = this.getParserMap().get(BINDING_DEFAULT);
        }
        return bindingParser.parse(string, metaDataSource);
    }

    protected Map<String, BindingParser> getParserMap() {
        if (this.parserMap == null) {
            this.parserMap = new HashMap<String, BindingParser>();
            this.parserMap.put(BINDING_DEFAULT, new DefaultTemplateParser());
            this.parserMap.put(BINDING_FIELD, new FieldParser());
            this.parserMap.put(BINDING_VIEW, new ViewParser());
        }
        return this.parserMap;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ViewParser
    extends DefaultTemplateParser {
        private ViewParser() {
        }

        @Override
        public List<String> parse(String string, MetaDataSource metaDataSource) {
            List<String> list = super.parse(string, metaDataSource);
            if (list != null && metaDataSource != null) {
                if (string.indexOf(".") != -1) {
                    throw new BindingKeyListProviderException("Wrong view binding format: " + string + ". " + "Correct format for views: view.dataset " + "Example: view.kontrah");
                }
                DataSetDef dataSetDef = metaDataSource.getDataSetDef(string);
                if (dataSetDef != null && dataSetDef.getName() != null) {
                    list.add(dataSetDef.getName());
                }
            }
            return list;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FieldParser
    extends DefaultTemplateParser {
        private FieldParser() {
        }

        @Override
        public List<String> parse(String string, MetaDataSource metaDataSource) {
            List<String> list = super.parse(string, metaDataSource);
            if (list != null && metaDataSource != null) {
                String[] stringArray = string.split("\\.");
                if (stringArray.length != 2) {
                    throw new BindingKeyListProviderException("Wrong field binding format: field." + string + ". " + "Correct format for fields: field.dataset.fieldName " + "Example: field.kontrah.nazwa");
                }
                FieldDef fieldDef = metaDataSource.getFieldDef(stringArray[0], stringArray[1]);
                if (fieldDef != null) {
                    if (fieldDef.getDomainName() != null) {
                        list.add(fieldDef.getDomainName());
                    }
                    if (fieldDef.getType() != null) {
                        list.add(fieldDef.getType().toString().toLowerCase());
                    }
                }
            }
            return list;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DefaultTemplateParser
    implements BindingParser {
        private DefaultTemplateParser() {
        }

        @Override
        public List<String> parse(String string, MetaDataSource metaDataSource) {
            if (string == null) {
                return null;
            }
            String string2 = string;
            ArrayList<String> arrayList = new ArrayList<String>();
            while (true) {
                arrayList.add(string2);
                int n = string2.indexOf(".");
                if (n == -1) break;
                string2 = string2.substring(n + 1, string2.length());
            }
            return arrayList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface BindingParser {
        public List<String> parse(String var1, MetaDataSource var2);
    }
}

