/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.lib.commons.comas.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import pl.com.stream.lib.commons.comas.BindAction;
import pl.com.stream.lib.commons.comas.Command;
import pl.com.stream.lib.commons.comas.CommandBindLevel;
import pl.com.stream.lib.commons.comas.CommandsLevel;
import pl.com.stream.lib.commons.comas.CommandsManager;
import pl.com.stream.lib.commons.comas.impl.DefaultBindAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCommandsLevel
implements CommandsLevel {
    private static final Logger logger = Logger.getLogger(DefaultCommandsLevel.class);
    private final CommandsLevel parent;
    private JComponent component;
    private final List<CommandsLevel> childList = new ArrayList<CommandsLevel>();
    private CommandsLevel activeChild;
    private final CommandsManager commandsManager;
    private final Map<KeyStroke, List<BindAction>> bindActionMap = new HashMap<KeyStroke, List<BindAction>>();

    public DefaultCommandsLevel(CommandsManager commandsManager, CommandsLevel commandsLevel) {
        this(commandsManager, commandsLevel, null);
    }

    public DefaultCommandsLevel(CommandsManager commandsManager, CommandsLevel commandsLevel, JComponent jComponent) {
        this.commandsManager = commandsManager;
        this.parent = commandsLevel;
        this.setLevelComponent(jComponent);
    }

    @Override
    public void activateChildPath() {
        if (logger.isDebugEnabled()) {
            logger.debug("Activate path in " + this);
            Set<KeyStroke> set = this.bindActionMap.keySet();
            for (KeyStroke keyStroke : set) {
                logger.debug(" Key stroke " + keyStroke);
                List<BindAction> list = this.bindActionMap.get(keyStroke);
                for (BindAction bindAction : list) {
                    logger.debug("  Bind action " + bindAction.getAction());
                }
            }
        }
        if (this.parent != null) {
            this.parent.activateChildPath();
            this.parent.setActiveChild(this);
        }
        this.activeChild = null;
    }

    @Override
    public void addBindAction(BindAction bindAction) {
        KeyStroke keyStroke = bindAction.getKeyStroke();
        List<BindAction> list = this.bindActionMap.get(keyStroke);
        if (list == null) {
            list = new ArrayList<BindAction>();
            this.bindActionMap.put(keyStroke, list);
        }
        list.add(bindAction);
    }

    @Override
    public void bindAction(Action action, String string) {
        this.bindAction(action, string, CommandBindLevel.LOCAL);
    }

    @Override
    public void bindAction(Action action, String string, CommandBindLevel commandBindLevel) {
        Command command = this.commandsManager.getCommand(string);
        if (command != null) {
            KeyStroke keyStroke = command.getKeyStroke();
            DefaultBindAction defaultBindAction = new DefaultBindAction(action, keyStroke, this);
            action.putValue("AcceleratorKey", keyStroke);
            switch (commandBindLevel) {
                case LOCAL: {
                    this.addBindAction(defaultBindAction);
                    break;
                }
                case GROUP: {
                    if (this.parent != null) {
                        this.parent.addBindAction(defaultBindAction);
                        break;
                    }
                    this.addBindAction(defaultBindAction);
                    break;
                }
                case GLOBAL: {
                    CommandsLevel commandsLevel = this.commandsManager.getRootLevel();
                    if (commandsLevel != null) {
                        commandsLevel.addBindAction(defaultBindAction);
                        break;
                    }
                    this.addBindAction(defaultBindAction);
                }
            }
        } else {
            throw new IllegalArgumentException("Command " + string + " is not register");
        }
    }

    @Override
    public CommandsLevel createChild() {
        DefaultCommandsLevel defaultCommandsLevel = new DefaultCommandsLevel(this.commandsManager, this);
        this.childList.add(defaultCommandsLevel);
        return defaultCommandsLevel;
    }

    @Override
    public CommandsLevel createChild(JComponent jComponent) {
        CommandsLevel commandsLevel = this.createChild();
        commandsLevel.setLevelComponent(jComponent);
        return commandsLevel;
    }

    @Override
    public void dispose() {
        this.commandsManager.cutLevel(this);
        this.component = null;
    }

    @Override
    public List<BindAction> getBindActionList(KeyStroke keyStroke) {
        List<BindAction> list;
        if (this.activeChild != null && this.childList.contains(this.activeChild) && (list = this.activeChild.getBindActionList(keyStroke)) != null) {
            return list;
        }
        return this.bindActionMap.get(keyStroke);
    }

    @Override
    public List<CommandsLevel> getChildList() {
        return this.childList;
    }

    @Override
    public JComponent getLevelComponent() {
        return this.component;
    }

    @Override
    public CommandsLevel getParent() {
        return this.parent;
    }

    @Override
    public void removeAllBindActionsFromLevel(CommandsLevel commandsLevel) {
        Set<KeyStroke> set = this.bindActionMap.keySet();
        for (KeyStroke keyStroke : set) {
            List<BindAction> list = this.bindActionMap.get(keyStroke);
            int n = 0;
            while (n <= list.size() - 1) {
                BindAction bindAction = list.get(n);
                if (bindAction.getCommandsLevel() == commandsLevel) {
                    list.remove(n);
                    continue;
                }
                ++n;
            }
            if (list.size() != 0) continue;
            this.bindActionMap.remove(keyStroke);
        }
    }

    @Override
    public void removeChild(CommandsLevel commandsLevel) {
        this.childList.remove(commandsLevel);
    }

    @Override
    public void setActiveChild(CommandsLevel commandsLevel) {
        this.activeChild = commandsLevel;
    }

    @Override
    public void setLevelComponent(JComponent jComponent) {
        if (jComponent != null) {
            this.component = jComponent;
            this.commandsManager.addLevel(this);
        }
    }
}

