/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.lib.commons.comas.impl;

import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import pl.com.stream.lib.commons.comas.BindAction;
import pl.com.stream.lib.commons.comas.Command;
import pl.com.stream.lib.commons.comas.CommandsLevel;
import pl.com.stream.lib.commons.comas.CommandsManager;
import pl.com.stream.lib.commons.comas.PopUpMenuFactory;
import pl.com.stream.lib.commons.comas.impl.DefaultCommand;
import pl.com.stream.lib.commons.comas.impl.DefaultCommandsLevel;
import pl.com.stream.lib.commons.comas.impl.FireCommandsAction;

public class DefauldCommandsManager
implements CommandsManager,
PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(DefauldCommandsManager.class);
    private final Map<String, Command> commandMap = new HashMap<String, Command>();
    private final Map<JComponent, CommandsLevel> levelMap = new HashMap<JComponent, CommandsLevel>();
    private CommandsLevel rootLevel;
    private final KeyboardFocusManager keyboardFocusManager;
    private final PopUpMenuFactory popUpMenuFactory;
    private InputMap rootInputMap;
    private ActionMap rootActionMap;

    public DefauldCommandsManager(PopUpMenuFactory popUpMenuFactory) {
        this.popUpMenuFactory = popUpMenuFactory;
        this.keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        this.keyboardFocusManager.addPropertyChangeListener(this);
    }

    public CommandsLevel createRootLevel(JComponent jComponent) {
        this.rootLevel = new DefaultCommandsLevel(this, null, jComponent);
        this.levelMap.put(jComponent, this.rootLevel);
        this.rootInputMap = jComponent.getInputMap(2);
        this.rootActionMap = jComponent.getActionMap();
        this.rootInputMap.clear();
        this.rootActionMap.clear();
        Set<String> set = this.commandMap.keySet();
        for (String string : set) {
            Command command = this.commandMap.get(string);
            FireCommandsAction fireCommandsAction = new FireCommandsAction(this, command.getKeyStroke());
            this.rootInputMap.put(command.getKeyStroke(), fireCommandsAction);
            this.rootActionMap.put(fireCommandsAction, fireCommandsAction);
        }
        return this.rootLevel;
    }

    public void registerCommand(String string, String string2, KeyStroke keyStroke) {
        Command command = this.commandMap.get(string);
        if (command == null) {
            command = new DefaultCommand(string, string2, keyStroke);
            this.commandMap.put(string, command);
            if (this.rootInputMap != null) {
                FireCommandsAction fireCommandsAction = new FireCommandsAction(this, command.getKeyStroke());
                this.rootInputMap.put(command.getKeyStroke(), fireCommandsAction);
                this.rootActionMap.put(fireCommandsAction, fireCommandsAction);
            }
        } else {
            throw new IllegalArgumentException("Command " + string + " already register.");
        }
    }

    public CommandsLevel getRootLevel() {
        return this.rootLevel;
    }

    public Command getCommand(String string) {
        return this.commandMap.get(string);
    }

    public void cutLevel(CommandsLevel commandsLevel) {
        this.levelMap.remove(commandsLevel.getLevelComponent());
        CommandsLevel commandsLevel2 = commandsLevel.getParent();
        if (commandsLevel2 != null) {
            commandsLevel2.removeChild(commandsLevel);
            commandsLevel2.removeAllBindActionsFromLevel(commandsLevel);
        }
        this.removeAllBindActionsFromRoot(commandsLevel);
    }

    private void removeAllBindActionsFromRoot(CommandsLevel commandsLevel) {
        if (this.rootLevel != null) {
            this.rootLevel.removeAllBindActionsFromLevel(commandsLevel);
            List<CommandsLevel> list = commandsLevel.getChildList();
            for (CommandsLevel commandsLevel2 : list) {
                this.removeAllBindActionsFromRoot(commandsLevel2);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object;
        String string = propertyChangeEvent.getPropertyName();
        if ("focusOwner".equals(string) && propertyChangeEvent.getNewValue() != null && (object = propertyChangeEvent.getNewValue()) instanceof Container) {
            for (Container container = (Container)object; container != null; container = container.getParent()) {
                CommandsLevel commandsLevel = this.levelMap.get(container);
                if (commandsLevel == null) continue;
                logger.debug("######Start activate path#####");
                commandsLevel.activateChildPath();
                return;
            }
        }
    }

    public void dispose() {
        this.keyboardFocusManager.removePropertyChangeListener(this);
        this.rootLevel = null;
        Collection<CommandsLevel> collection = this.levelMap.values();
        ArrayList<CommandsLevel> arrayList = new ArrayList<CommandsLevel>();
        for (CommandsLevel commandsLevel : collection) {
            arrayList.add(commandsLevel);
        }
        this.levelMap.clear();
        for (CommandsLevel commandsLevel : arrayList) {
            commandsLevel.dispose();
        }
        this.commandMap.clear();
        if (this.rootInputMap != null) {
            this.rootInputMap.clear();
        }
        this.rootInputMap = null;
        if (this.rootActionMap != null) {
            this.rootActionMap.clear();
        }
        this.rootActionMap = null;
    }

    public void fireCommands(KeyStroke keyStroke) {
        List<BindAction> list;
        if (this.rootLevel != null && (list = this.rootLevel.getBindActionList(keyStroke)) != null) {
            if (list.size() == 1) {
                BindAction bindAction = list.get(0);
                bindAction.execute();
            } else if (list.size() > 1) {
                ArrayList<BindAction> arrayList = new ArrayList<BindAction>();
                Object object = list.iterator();
                while (object.hasNext()) {
                    BindAction bindAction = object.next();
                    if (!bindAction.getAction().isEnabled()) continue;
                    arrayList.add(bindAction);
                }
                if (arrayList.size() == 1) {
                    object = (BindAction)arrayList.get(0);
                    object.execute();
                } else if (arrayList.size() > 1 && (object = this.popUpMenuFactory.createPopupMenu()) != null) {
                    for (BindAction bindAction : arrayList) {
                        JMenuItem jMenuItem = this.popUpMenuFactory.createMenuItem(bindAction.getAction());
                        ((JPopupMenu)object).add(jMenuItem);
                    }
                    ((JPopupMenu)object).show(((BindAction)arrayList.get(0)).getCommandsLevel().getLevelComponent(), 0, 0);
                }
            }
        }
    }

    public void registerCommand(String string, String string2, String string3) {
        this.registerCommand(string, string2, KeyStroke.getKeyStroke(string3));
    }

    public CommandsLevel getLevelForComponent(JComponent jComponent) {
        return this.levelMap.get(jComponent);
    }

    public CommandsLevel getFirstLevelForComponent(JComponent jComponent) {
        for (Container container = jComponent; container != null; container = container.getParent()) {
            CommandsLevel commandsLevel = this.levelMap.get(container);
            if (commandsLevel == null) continue;
            return commandsLevel;
        }
        return null;
    }

    public void addLevel(CommandsLevel commandsLevel) {
        this.levelMap.put(commandsLevel.getLevelComponent(), commandsLevel);
    }
}

