/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.lib.commons.actionlunchpanel.internal;

import javax.swing.JLabel;
import pl.com.stream.lib.commons.actionlunchpanel.LunchAction;
import pl.com.stream.lib.commons.actionlunchpanel.internal.AnimationComputor;

public abstract class BasicAnimatedComponent
extends JLabel {
    private static final long serialVersionUID = -1364933985212415615L;
    private static final double TIME_PRESENT_LEVEL = 0.01;
    private static final double TIME_COMPLETE_LEVEL = 0.99;
    private static final double TIME_HALF_LEVEL = 0.5;
    private static final double TIME_BEFOREFULL_LEVEL = 0.9;
    protected double focusTime;
    protected double clickTime;
    protected double startTime;
    protected final int no;
    private final LunchAction lunchAction;
    protected final AnimationComputor animationComputor;

    public BasicAnimatedComponent(LunchAction lunchAction, int n, AnimationComputor animationComputor) {
        this.lunchAction = lunchAction;
        this.no = n;
        this.animationComputor = animationComputor;
    }

    public double getClickTime() {
        return this.clickTime;
    }

    public double getFocusTime() {
        return this.focusTime;
    }

    public void setClickTime(double d) {
        this.clickTime = d;
        this.recompute();
    }

    public void setFocusTime(double d) {
        this.focusTime = d;
        this.recompute();
    }

    public void recompute() {
        this.animationComputor.compute(this);
    }

    public int getNo() {
        return this.no;
    }

    public void setStartTime(double d) {
        this.startTime = d;
        this.recompute();
    }

    public double getStartTime() {
        return this.startTime;
    }

    public LunchAction getLunchAction() {
        return this.lunchAction;
    }

    public boolean getFocusTimePresent() {
        return this.focusTime > 0.01;
    }

    public boolean getHalfFocusTimePresent() {
        return this.focusTime > 0.5;
    }

    public boolean getHalfStartTimePresent() {
        return this.startTime > 0.5;
    }

    protected boolean getStartTimeComplete() {
        return this.startTime > 0.99;
    }

    protected boolean getBeforeFullStartTimePresent() {
        return this.startTime > 0.9;
    }
}

