/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.lib.commons.actionlunchpanel.internal;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Timer;
import java.util.TimerTask;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTarget;
import org.jdesktop.animation.timing.interpolation.Interpolator;
import org.jdesktop.animation.timing.interpolation.KeyFrames;
import org.jdesktop.animation.timing.interpolation.KeyTimes;
import org.jdesktop.animation.timing.interpolation.KeyValues;
import org.jdesktop.animation.timing.interpolation.PropertySetter;
import org.jdesktop.animation.timing.interpolation.SplineInterpolator;
import pl.com.stream.lib.commons.actionlunchpanel.LunchAction;
import pl.com.stream.lib.commons.actionlunchpanel.internal.AnimationComputor;
import pl.com.stream.lib.commons.actionlunchpanel.internal.BasicAnimatedComponent;
import pl.com.stream.lib.commons.actionlunchpanel.internal.ShadowFactory;

public class AnimateIcon
extends BasicAnimatedComponent {
    private static final long serialVersionUID = 3943579458523103260L;
    public static final float SHADOW_ANGLE = 45.0f;
    public static final int SHADOW_DISTANCE = 10;
    public static final int SHADOW_MARGIN = 3;
    private static final int TIME_CLICK_ANIMATOR = 200;
    private static final int COUNT_CLICK_ANIMATOR = 4;
    private Animator startFocusAnimator;
    private Animator stopFocusAnimator;
    private Animator clickAnimator;
    private final BufferedImage shadow;
    private int shadow_distance_x = 0;
    private int shadow_distance_y = 0;
    private final BasicAnimatedComponent titleLabel;
    private final BasicAnimatedComponent descriptionLabel;

    public AnimateIcon(LunchAction lunchAction, int n, AnimationComputor animationComputor, BasicAnimatedComponent basicAnimatedComponent, BasicAnimatedComponent basicAnimatedComponent2) {
        super(lunchAction, n, animationComputor);
        this.titleLabel = basicAnimatedComponent;
        this.descriptionLabel = basicAnimatedComponent2;
        this.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                AnimateIcon.this.startPaintFocus();
            }

            public void mouseExited(MouseEvent mouseEvent) {
                AnimateIcon.this.stopPaintFocus();
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                AnimateIcon.this.startPaintClick();
                AnimateIcon.this.doLunch();
            }
        });
        ShadowFactory shadowFactory = new ShadowFactory(5, 0.5f, Color.BLACK);
        this.shadow = shadowFactory.createShadow(lunchAction.getBigImage());
    }

    protected void setAsCurrentIcon() {
    }

    public int getNo() {
        return this.no;
    }

    public void recompute() {
        this.animationComputor.compute(this);
    }

    public void startPaintClick() {
        if (this.clickAnimator != null && this.clickAnimator.isRunning()) {
            return;
        }
        SplineInterpolator splineInterpolator = new SplineInterpolator(0.0f, 1.0f, 1.0f, 1.0f);
        KeyTimes keyTimes = new KeyTimes(new float[]{0.0f, 1.0f});
        KeyValues keyValues = KeyValues.create((Object[])new Double[]{0.0, 1.0});
        KeyFrames keyFrames = new KeyFrames(keyValues, keyTimes, new Interpolator[]{splineInterpolator});
        this.clickAnimator = new Animator(200);
        this.clickAnimator.setRepeatBehavior(Animator.RepeatBehavior.REVERSE);
        this.clickAnimator.setRepeatCount(4.0);
        this.clickAnimator.setResolution(5);
        this.clickAnimator.setStartDelay(10);
        PropertySetter propertySetter = new PropertySetter((Object)this, "clickTime", keyFrames);
        this.clickAnimator.addTarget((TimingTarget)propertySetter);
        this.clickAnimator.start();
    }

    protected void doLunch() {
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            public void run() {
                AnimateIcon.this.getLunchAction().run();
            }
        }, 800L);
    }

    protected void paintComponent(Graphics graphics) {
        if (!this.isVisible()) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.setupGraphics(graphics2D);
        this.drawItem(graphics2D);
    }

    protected void startPaintFocus() {
        if (this.startFocusAnimator != null && this.startFocusAnimator.isRunning()) {
            return;
        }
        if (this.stopFocusAnimator != null && this.stopFocusAnimator.isRunning()) {
            this.stopFocusAnimator.stop();
        }
        SplineInterpolator splineInterpolator = new SplineInterpolator(0.0f, 1.0f, 1.0f, 1.0f);
        KeyTimes keyTimes = new KeyTimes(new float[]{0.0f, 1.0f});
        KeyValues keyValues = KeyValues.create((Object[])new Double[]{this.focusTime, 1.0});
        KeyFrames keyFrames = new KeyFrames(keyValues, keyTimes, new Interpolator[]{splineInterpolator});
        this.startFocusAnimator = new Animator(300);
        this.startFocusAnimator.setRepeatBehavior(Animator.RepeatBehavior.LOOP);
        this.startFocusAnimator.setRepeatCount(1.0);
        this.startFocusAnimator.setResolution(5);
        this.startFocusAnimator.setStartDelay(10);
        PropertySetter propertySetter = new PropertySetter((Object)this, "focusTime", keyFrames);
        this.startFocusAnimator.addTarget((TimingTarget)propertySetter);
        propertySetter = new PropertySetter((Object)this.titleLabel, "focusTime", keyFrames);
        this.startFocusAnimator.addTarget((TimingTarget)propertySetter);
        propertySetter = new PropertySetter((Object)this.descriptionLabel, "focusTime", keyFrames);
        this.startFocusAnimator.addTarget((TimingTarget)propertySetter);
        this.startFocusAnimator.start();
    }

    protected void stopPaintFocus() {
        if (this.stopFocusAnimator != null && this.stopFocusAnimator.isRunning()) {
            return;
        }
        if (this.startFocusAnimator != null && this.startFocusAnimator.isRunning()) {
            this.startFocusAnimator.stop();
        }
        SplineInterpolator splineInterpolator = new SplineInterpolator(0.0f, 1.0f, 1.0f, 1.0f);
        KeyTimes keyTimes = new KeyTimes(new float[]{0.0f, 1.0f});
        KeyValues keyValues = KeyValues.create((Object[])new Double[]{this.focusTime, 0.0});
        KeyFrames keyFrames = new KeyFrames(keyValues, keyTimes, new Interpolator[]{splineInterpolator});
        this.stopFocusAnimator = new Animator(400);
        this.stopFocusAnimator.setRepeatBehavior(Animator.RepeatBehavior.LOOP);
        this.stopFocusAnimator.setRepeatCount(1.0);
        this.stopFocusAnimator.setResolution(5);
        this.stopFocusAnimator.setStartDelay(10);
        PropertySetter propertySetter = new PropertySetter((Object)this, "focusTime", keyFrames);
        this.stopFocusAnimator.addTarget((TimingTarget)propertySetter);
        propertySetter = new PropertySetter((Object)this.titleLabel, "focusTime", keyFrames);
        this.stopFocusAnimator.addTarget((TimingTarget)propertySetter);
        propertySetter = new PropertySetter((Object)this.descriptionLabel, "focusTime", keyFrames);
        this.stopFocusAnimator.addTarget((TimingTarget)propertySetter);
        this.stopFocusAnimator.start();
    }

    private void computeShadowPosition(double d) {
        double d2 = Math.toRadians(45.0);
        this.shadow_distance_x = (int)(Math.cos(d2) * d);
        this.shadow_distance_y = (int)(Math.sin(d2) * d);
    }

    private void drawItem(Graphics2D graphics2D) {
        int n = 0;
        int n2 = 0;
        if (this.getFocusTimePresent()) {
            this.drawShadow(graphics2D);
            int n3 = this.getLunchAction().getBigImage().getWidth();
            int n4 = this.getLunchAction().getBigImage().getHeight();
            n3 = (int)((double)n3 - (1.0 - this.focusTime) * (double)(this.getLunchAction().getBigImage().getWidth() - this.getLunchAction().getSmallImage().getWidth()));
            n4 = (int)((double)n4 - (1.0 - this.focusTime) * (double)(this.getLunchAction().getBigImage().getHeight() - this.getLunchAction().getSmallImage().getHeight()));
            n = (this.getLunchAction().getBigImage().getWidth() + 10 + 3 - n3) / 2;
            n2 = (this.getLunchAction().getBigImage().getHeight() + 10 + 3 - n4) / 2;
            graphics2D.drawImage(this.getLunchAction().getBigImage(), n, n2, n3, n4, null);
        } else {
            int n5;
            int n6;
            if (this.getStartTimeComplete()) {
                n6 = this.getLunchAction().getSmallImage().getWidth();
                n5 = this.getLunchAction().getSmallImage().getHeight();
            } else {
                n6 = this.getWidth();
                n5 = this.getHeight();
            }
            graphics2D.drawImage(this.getLunchAction().getSmallImage(), n, n2, n6, n5, null);
        }
    }

    private void drawShadow(Graphics2D graphics2D) {
        double d = this.focusTime;
        int n = (int)((double)(this.shadow.getWidth() / 2) * (1.0 + d));
        int n2 = (int)((double)(this.shadow.getHeight() / 2) * (1.0 + d));
        int n3 = (this.getWidth() - n) / 2;
        int n4 = (this.getHeight() - n2) / 2;
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f - 0.5f * (float)d));
        this.computeShadowPosition(d * 10.0 + 1.0);
        graphics2D.drawImage(this.shadow, n3 + this.shadow_distance_x, n4 + this.shadow_distance_y, n, n2, null);
        graphics2D.setComposite(composite);
    }

    private void setupGraphics(Graphics2D graphics2D) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }
}

