/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.lib.commons.actionlunchpanel;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTarget;
import org.jdesktop.animation.timing.interpolation.Interpolator;
import org.jdesktop.animation.timing.interpolation.KeyFrames;
import org.jdesktop.animation.timing.interpolation.KeyTimes;
import org.jdesktop.animation.timing.interpolation.KeyValues;
import org.jdesktop.animation.timing.interpolation.PropertySetter;
import org.jdesktop.animation.timing.interpolation.SplineInterpolator;
import pl.com.stream.lib.commons.actionlunchpanel.LunchAction;
import pl.com.stream.lib.commons.actionlunchpanel.internal.AnimateDescriptionLabel;
import pl.com.stream.lib.commons.actionlunchpanel.internal.AnimateIcon;
import pl.com.stream.lib.commons.actionlunchpanel.internal.AnimateTitleLabel;
import pl.com.stream.lib.commons.actionlunchpanel.internal.AnimationComputor;
import pl.com.stream.lib.commons.actionlunchpanel.internal.BasicAnimatedComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionLunchPanel
extends JPanel {
    private static final long serialVersionUID = -3985801390625879473L;
    private final List<LunchAction> lunchActions = new ArrayList<LunchAction>();
    private final List<AnimateIcon> animatedIcons = new ArrayList<AnimateIcon>();
    private final List<AnimateTitleLabel> animatedTitleLabels = new ArrayList<AnimateTitleLabel>();
    private final List<AnimateDescriptionLabel> animatedDescriptionLabels = new ArrayList<AnimateDescriptionLabel>();
    private Animator startAnimator;
    private Image centerImage;
    private int startCircleFactor = 20;
    private int targetCircleFactor = 4;
    private boolean centerImageScaled = false;
    private double elipseFactor = 1.0;

    public ActionLunchPanel() {
        this.setBackground(Color.WHITE);
        this.setLayout(null);
    }

    public ActionLunchPanel(List<LunchAction> list) {
        this();
        this.lunchActions.addAll(list);
    }

    public ActionLunchPanel(LunchAction[] lunchActionArray) {
        this();
        for (LunchAction lunchAction : lunchActionArray) {
            this.lunchActions.add(lunchAction);
        }
    }

    public void addLunchAction(LunchAction lunchAction) {
        if (this.startAnimator != null && this.startAnimator.isRunning()) {
            throw new RuntimeException("Animation in progress, can not add lunch action.");
        }
        this.lunchActions.add(lunchAction);
    }

    public double getElipseFactor() {
        return this.elipseFactor;
    }

    public void setElipseFactor(double d) {
        this.elipseFactor = d;
    }

    public int getStartCircleFactor() {
        return this.startCircleFactor;
    }

    public void setStartCircleFactor(int n) {
        this.startCircleFactor = n;
    }

    public int getTargetCircleFactor() {
        return this.targetCircleFactor;
    }

    public void setTargetCircleFactor(int n) {
        this.targetCircleFactor = n;
    }

    public void setCenterImage(Image image) {
        this.centerImage = image;
        this.repaint();
    }

    public Image getCenterImage() {
        return this.centerImage;
    }

    public boolean isCenterImageScaled() {
        return this.centerImageScaled;
    }

    public void setCenterImageScaled(boolean bl) {
        this.centerImageScaled = bl;
    }

    public void start() {
        if (this.startAnimator != null && this.startAnimator.isRunning()) {
            return;
        }
        this.createComponents();
        this.startInitialAnimation();
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        for (AnimateIcon basicAnimatedComponent : this.animatedIcons) {
            ((BasicAnimatedComponent)basicAnimatedComponent).recompute();
        }
        for (AnimateTitleLabel animateTitleLabel : this.animatedTitleLabels) {
            animateTitleLabel.recompute();
        }
        for (AnimateDescriptionLabel animateDescriptionLabel : this.animatedDescriptionLabels) {
            animateDescriptionLabel.recompute();
        }
    }

    protected Rectangle getCenterImageRectangle() {
        if (this.centerImage != null) {
            int n;
            int n2;
            if (this.isCenterImageScaled()) {
                n2 = this.getWidth() / this.targetCircleFactor;
                n = this.getHeight() / this.targetCircleFactor;
            } else {
                n2 = this.centerImage.getWidth(null);
                n = this.centerImage.getHeight(null);
            }
            int n3 = (this.getWidth() - n2) / 2;
            int n4 = (this.getHeight() - n) / 2 - (this.getHeight() - n) / 10;
            return new Rectangle(n3, n4, n2, n);
        }
        return null;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.centerImage != null) {
            Rectangle rectangle = this.getCenterImageRectangle();
            graphics.drawImage(this.centerImage, rectangle.x, rectangle.y, rectangle.width, rectangle.height, null);
        }
    }

    private void createComponents() {
        for (AnimateIcon object2 : this.animatedIcons) {
            this.remove(object2);
        }
        for (AnimateTitleLabel animateTitleLabel : this.animatedTitleLabels) {
            this.remove(animateTitleLabel);
        }
        for (AnimateDescriptionLabel animateDescriptionLabel : this.animatedDescriptionLabels) {
            this.remove(animateDescriptionLabel);
        }
        this.repaint();
        this.animatedIcons.clear();
        this.animatedTitleLabels.clear();
        this.animatedDescriptionLabels.clear();
        int n = 0;
        IconAnimationComputor iconAnimationComputor = new IconAnimationComputor();
        LabelTitleAnimationComputor labelTitleAnimationComputor = new LabelTitleAnimationComputor();
        LabelDescriptionAnimationComputor labelDescriptionAnimationComputor = new LabelDescriptionAnimationComputor();
        for (LunchAction lunchAction : this.lunchActions) {
            AnimateTitleLabel animateTitleLabel = new AnimateTitleLabel(lunchAction, n, labelTitleAnimationComputor);
            this.animatedTitleLabels.add(animateTitleLabel);
            this.add(animateTitleLabel);
            AnimateDescriptionLabel animateDescriptionLabel = new AnimateDescriptionLabel(lunchAction, n, labelDescriptionAnimationComputor);
            this.animatedDescriptionLabels.add(animateDescriptionLabel);
            this.add(animateDescriptionLabel);
            AnimateIcon animateIcon = new AnimateIcon(lunchAction, n++, iconAnimationComputor, animateTitleLabel, animateDescriptionLabel);
            this.animatedIcons.add(animateIcon);
            this.add(animateIcon);
        }
    }

    private void startInitialAnimation() {
        PropertySetter propertySetter;
        if (this.animatedIcons.size() == 0) {
            return;
        }
        SplineInterpolator splineInterpolator = new SplineInterpolator(0.25f, 1.0f, 0.01f, 1.0f);
        KeyTimes keyTimes = new KeyTimes(new float[]{0.0f, 1.0f});
        KeyValues keyValues = KeyValues.create((Object[])new Double[]{0.0, 1.0});
        KeyFrames keyFrames = new KeyFrames(keyValues, keyTimes, new Interpolator[]{splineInterpolator});
        this.startAnimator = new Animator(1000);
        this.startAnimator.setRepeatBehavior(Animator.RepeatBehavior.LOOP);
        this.startAnimator.setRepeatCount(1.0);
        for (AnimateIcon basicAnimatedComponent : this.animatedIcons) {
            propertySetter = new PropertySetter((Object)basicAnimatedComponent, "startTime", keyFrames);
            this.startAnimator.addTarget((TimingTarget)propertySetter);
        }
        for (AnimateTitleLabel animateTitleLabel : this.animatedTitleLabels) {
            propertySetter = new PropertySetter((Object)animateTitleLabel, "startTime", keyFrames);
            this.startAnimator.addTarget((TimingTarget)propertySetter);
        }
        this.startAnimator.start();
    }

    @Override
    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        super.paint(graphics);
    }

    private class LabelDescriptionAnimationComputor
    implements AnimationComputor {
        private LabelDescriptionAnimationComputor() {
        }

        public void compute(Object object) {
            AnimateDescriptionLabel animateDescriptionLabel = (AnimateDescriptionLabel)object;
            double d = Math.min(ActionLunchPanel.this.getWidth(), ActionLunchPanel.this.getHeight()) / (ActionLunchPanel.this.startCircleFactor - (ActionLunchPanel.this.startCircleFactor - ActionLunchPanel.this.targetCircleFactor));
            int n = (int)((double)(ActionLunchPanel.this.getHeight() / 2) - d / 10.0);
            n = (int)((double)n + (1.0 - animateDescriptionLabel.getFocusTime() * (d / 8.0)));
            int n2 = (int)(d * 2.0);
            int n3 = (int)(d * 2.0 / 3.0);
            int n4 = (ActionLunchPanel.this.getWidth() - n2) / 2;
            animateDescriptionLabel.setBounds(n4, n, n2, n3);
            animateDescriptionLabel.repaint();
        }
    }

    private class LabelTitleAnimationComputor
    implements AnimationComputor {
        private LabelTitleAnimationComputor() {
        }

        public void compute(Object object) {
            BasicAnimatedComponent basicAnimatedComponent = (BasicAnimatedComponent)object;
            double d = basicAnimatedComponent.getStartTime();
            int n = basicAnimatedComponent.getNo();
            double d2 = (double)Math.min(ActionLunchPanel.this.getWidth(), ActionLunchPanel.this.getHeight()) / ((double)ActionLunchPanel.this.startCircleFactor - (double)(ActionLunchPanel.this.startCircleFactor - ActionLunchPanel.this.targetCircleFactor) * d);
            double d3 = d * Math.PI - 1.5707963267948966 + Math.PI * 2 * (double)n / (double)ActionLunchPanel.this.animatedIcons.size();
            double d4 = Math.cos(d3) * d2 * ActionLunchPanel.this.getElipseFactor();
            double d5 = Math.sin(d3) * d2;
            d5 -= (double)basicAnimatedComponent.getLunchAction().getSmallImage().getHeight(null);
            int n2 = basicAnimatedComponent.getLunchAction().getSmallImage().getWidth(null) * 3;
            int n3 = basicAnimatedComponent.getPreferredSize().height;
            int n4 = (int)(basicAnimatedComponent.getFocusTime() * (double)n2);
            if (n4 % 2 == 1) {
                ++n4;
            }
            n2 += n4;
            n2 = (int)((double)n2 - (1.0 - d) * (double)n2 / 1.0);
            n3 = (int)((double)n3 - (1.0 - d) * (double)n3 / 1.0);
            int n5 = (ActionLunchPanel.this.getWidth() - n2) / 2;
            int n6 = (ActionLunchPanel.this.getHeight() - n3) / 2;
            double d6 = basicAnimatedComponent.getClickTime();
            n3 = (int)((double)n3 + d6 * 12.0);
            n6 = (int)((double)n6 - d6 * 12.0);
            basicAnimatedComponent.setBounds((int)((double)n5 - d4), (int)((double)n6 - d5), n2, n3);
            basicAnimatedComponent.repaint();
        }
    }

    private class IconAnimationComputor
    implements AnimationComputor {
        private IconAnimationComputor() {
        }

        public void compute(Object object) {
            int n;
            int n2;
            BasicAnimatedComponent basicAnimatedComponent = (BasicAnimatedComponent)object;
            double d = basicAnimatedComponent.getStartTime();
            int n3 = basicAnimatedComponent.getNo();
            double d2 = (double)Math.min(ActionLunchPanel.this.getWidth(), ActionLunchPanel.this.getHeight()) / ((double)ActionLunchPanel.this.startCircleFactor - (double)(ActionLunchPanel.this.startCircleFactor - ActionLunchPanel.this.targetCircleFactor) * d);
            double d3 = d * Math.PI - 1.5707963267948966 + Math.PI * 2 * (double)n3 / (double)ActionLunchPanel.this.animatedIcons.size();
            double d4 = Math.cos(d3) * d2 * ActionLunchPanel.this.getElipseFactor();
            double d5 = Math.sin(d3) * d2;
            boolean bl = basicAnimatedComponent.getFocusTimePresent();
            if (bl) {
                n2 = basicAnimatedComponent.getLunchAction().getBigImage().getWidth(null) + 10 + 3;
                n = basicAnimatedComponent.getLunchAction().getBigImage().getHeight(null) + 10 + 3;
            } else {
                n2 = basicAnimatedComponent.getLunchAction().getSmallImage().getWidth(null);
                n = basicAnimatedComponent.getLunchAction().getSmallImage().getHeight(null);
            }
            n2 = (int)((double)n2 - (1.0 - d) * (double)n2 / 1.0);
            n = (int)((double)n - (1.0 - d) * (double)n / 1.0);
            int n4 = (ActionLunchPanel.this.getWidth() - n2) / 2;
            int n5 = (ActionLunchPanel.this.getHeight() - n) / 2;
            double d6 = basicAnimatedComponent.getClickTime();
            n = (int)((double)n + d6 * 12.0);
            n5 = (int)((double)n5 - d6 * 12.0);
            basicAnimatedComponent.setBounds((int)((double)n4 - d4), (int)((double)n5 - d5), n2, n);
            basicAnimatedComponent.repaint();
        }
    }
}

