/*
 * Decompiled with CFR 0.152.
 */
package echopoint.util.throwable;

import echopoint.util.ReflectionKit;
import echopoint.util.throwable.ThrowableDescriptor;
import echopoint.util.throwable.ThrowablePropertyDescriptor;
import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ThrowableKit {
    private ThrowableKit() {
    }

    public static Throwable makeThrowable(Class throwableClass, String message, Throwable cause) {
        if (throwableClass == null || !Throwable.class.isAssignableFrom(throwableClass)) {
            throw new IllegalArgumentException("The class you provided :" + throwableClass + " is not derived from Throwable.class");
        }
        try {
            Constructor c = throwableClass.getDeclaredConstructor(String.class, Throwable.class);
            Object t = c.newInstance(message, cause);
            return (Throwable)t;
        }
        catch (Exception e) {
            try {
                String messageText = message == null ? cause.toString() : message + " : " + cause.toString();
                Constructor c = throwableClass.getDeclaredConstructor(String.class);
                Object t = c.newInstance(messageText);
                return (Throwable)t;
            }
            catch (Exception e2) {
                throw new IllegalStateException("A constructor(String) was not available for class :" + throwableClass);
            }
        }
    }

    public static Throwable makeThrowable(Class throwableClass, Throwable cause) {
        return ThrowableKit.makeThrowable(throwableClass, null, cause);
    }

    public static RuntimeException makeRuntimeException(String message, Throwable cause) {
        return (RuntimeException)ThrowableKit.makeThrowable(RuntimeException.class, message, cause);
    }

    public static RuntimeException makeRuntimeException(Throwable cause) {
        return ThrowableKit.makeRuntimeException(null, cause);
    }

    public static Throwable attachCause(Throwable throwable, Throwable cause) {
        try {
            Method m = Throwable.class.getDeclaredMethod("initCause", Throwable.class);
            throwable = (Throwable)m.invoke((Object)throwable, cause);
        }
        catch (SecurityException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (IllegalStateException e) {
        }
        catch (InvocationTargetException e) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return throwable;
    }

    public static Throwable initCause(Throwable throwable, Throwable cause) {
        return ThrowableKit.attachCause(throwable, cause);
    }

    public static ThrowableDescriptor describeThrowable(Throwable throwable) {
        HashMap<Throwable, Throwable> seenThrowables = new HashMap<Throwable, Throwable>();
        ThrowableDescriptor descriptor = new ThrowableDescriptor(throwable);
        seenThrowables.put(throwable, throwable);
        ThrowableKit.examineThrowable(descriptor, throwable, seenThrowables);
        return descriptor;
    }

    private static void examineThrowable(ThrowableDescriptor descriptor, Throwable throwable, Map seenThrowables) {
        Method[] properties = ReflectionKit.getAllDeclaredMethods(throwable.getClass());
        ArrayList<ThrowablePropertyDescriptor> propertyList = new ArrayList<ThrowablePropertyDescriptor>(properties.length);
        ArrayList<ThrowableDescriptor> causeList = new ArrayList<ThrowableDescriptor>(properties.length);
        String throwableMessage = throwable.getMessage();
        for (Method getter : properties) {
            String name;
            Class<?> type;
            Object value;
            int modifiers;
            block8: {
                if (!ReflectionKit.isGetter(getter)) continue;
                modifiers = getter.getModifiers();
                try {
                    getter.setAccessible(true);
                    value = getter.invoke((Object)throwable, new Object[0]);
                    type = getter.getReturnType();
                    name = ReflectionKit.decapitalize(getter.getName());
                    if (name.equals("class") || name.equals("message") || name.equals("ourStackTrace") || name.equals("stackTraceDepth")) continue;
                    if (name.equals("stackTrace")) {
                    }
                    break block8;
                }
                catch (IllegalArgumentException e1) {
                }
                catch (SecurityException e1) {
                }
                catch (IllegalAccessException e1) {
                }
                catch (InvocationTargetException e1) {}
                continue;
            }
            if (Throwable.class.isAssignableFrom(type)) {
                Throwable child;
                if (value == null || seenThrowables.containsKey(child = (Throwable)value)) continue;
                seenThrowables.put(child, child);
                ThrowableDescriptor childDesc = new ThrowableDescriptor(child);
                ThrowableKit.examineThrowable(childDesc, child, seenThrowables);
                causeList.add(childDesc);
                continue;
            }
            if (value == throwableMessage) continue;
            ThrowablePropertyDescriptor propertyDesc = new ThrowablePropertyDescriptor(type, name, value, modifiers);
            propertyList.add(propertyDesc);
        }
        descriptor.setCauses(causeList.toArray(new ThrowableDescriptor[causeList.size()]));
        descriptor.setProperties(propertyList.toArray(new ThrowablePropertyDescriptor[propertyList.size()]));
        descriptor.setStackTrace(ThrowableKit.examineStackTrace(throwable));
    }

    private static String[] examineStackTrace(Throwable parentThrowable) {
        CharArrayWriter caw = new CharArrayWriter();
        PrintWriter pw = new PrintWriter(caw);
        parentThrowable.printStackTrace(pw);
        ArrayList<String> stackTraceList = new ArrayList<String>();
        StringReader sr = new StringReader(caw.toString());
        BufferedReader reader = new BufferedReader(sr);
        boolean atStart = true;
        while (true) {
            String line = null;
            try {
                line = reader.readLine();
            }
            catch (IOException e) {
                // empty catch block
            }
            if (line == null || line.startsWith("Caused by")) break;
            if (atStart) {
                atStart = false;
                continue;
            }
            stackTraceList.add(line);
        }
        return stackTraceList.toArray(new String[stackTraceList.size()]);
    }

    public static void printThrowableDescription(Throwable throwable, PrintStream out, boolean indent) {
        if (throwable == null || out == null) {
            return;
        }
        ThrowableDescriptor desc = ThrowableKit.describeThrowable(throwable);
        ThrowableKit.printThrowableDescription0(desc, out, -1, indent);
    }

    public static void printThrowableDescription(Throwable throwable, PrintStream out) {
        ThrowableKit.printThrowableDescription(throwable, out, true);
    }

    private static void printThrowableDescription0(ThrowableDescriptor desc, PrintStream out, int tabLevel, boolean indent) {
        ThrowableDescriptor[] causes;
        String[] stackTrace;
        ThrowablePropertyDescriptor[] properties;
        if (indent) {
            ++tabLevel;
        }
        boolean doneHeader = false;
        ThrowableKit.printTabs(out, tabLevel);
        out.print(desc.getType().getName());
        out.print(" : ");
        out.print(desc.getMessage());
        out.println();
        for (ThrowablePropertyDescriptor property : properties = desc.getProperties()) {
            if (!doneHeader) {
                doneHeader = true;
                ThrowableKit.printTabs(out, tabLevel);
                out.println("Properties : ");
            }
            ThrowableKit.printTabs(out, tabLevel);
            out.print('\t');
            out.print(property.getName());
            out.print(" : ");
            out.print(property.getValueAsString());
            out.print(" (");
            out.print(property.getType().getName());
            out.print(" ");
            String modifiers = Modifier.toString(property.getModifiers());
            out.print(modifiers == null || modifiers.length() == 0 ? "default" : modifiers);
            out.print(")");
            out.println();
        }
        doneHeader = false;
        for (String aStackTrace : stackTrace = desc.getStackTrace()) {
            if (!doneHeader) {
                doneHeader = true;
                ThrowableKit.printTabs(out, tabLevel);
                out.println("Stack Trace : ");
            }
            ThrowableKit.printTabs(out, tabLevel);
            out.println(aStackTrace);
        }
        doneHeader = false;
        for (ThrowableDescriptor cause : causes = desc.getCauses()) {
            if (!doneHeader) {
                doneHeader = true;
                ThrowableKit.printTabs(out, tabLevel);
                out.println("Caused By : ");
            }
            ThrowableKit.printThrowableDescription0(cause, out, tabLevel, indent);
        }
    }

    private static void printTabs(PrintStream out, int tabLevel) {
        for (int i = 0; i < tabLevel; ++i) {
            out.print("\t");
        }
    }
}

