/*
 * Decompiled with CFR 0.152.
 */
package echopoint.util.throwable;

import echopoint.util.throwable.ThrowablePropertyDescriptor;

public class ThrowableDescriptor
extends ThrowablePropertyDescriptor {
    private Throwable throwable;
    private String message;
    private ThrowableDescriptor[] causes;
    private ThrowablePropertyDescriptor[] properties;
    private String[] stackTrace;

    ThrowableDescriptor(Throwable throwable) {
        this.setThrowable(throwable);
        this.setMessage(throwable.getLocalizedMessage());
        this.setType(throwable.getClass());
        this.setValue(this.message);
        this.setName(throwable.getClass().getName());
        this.setCauses(new ThrowableDescriptor[0]);
        this.setStackTrace(new String[0]);
        this.setProperties(new ThrowablePropertyDescriptor[0]);
        this.setModifiers(throwable.getClass().getModifiers());
    }

    public ThrowableDescriptor[] getCauses() {
        return this.causes;
    }

    public String getMessage() {
        return this.message;
    }

    public String[] getStackTrace() {
        return this.stackTrace;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public ThrowablePropertyDescriptor[] getProperties() {
        return this.properties;
    }

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append(this.getType().getName());
        sb.append(':');
        sb.append(this.message);
        for (i = 0; i < this.properties.length; ++i) {
            sb.append(' ');
            sb.append(this.properties[i].getName());
            sb.append(':');
            sb.append(this.properties[i].getValueAsString());
        }
        for (i = 0; i < this.causes.length; ++i) {
            sb.append(' ');
            sb.append(this.causes[i].getName());
            sb.append(':');
            sb.append(this.causes[i].getValueAsString());
        }
        return sb.toString();
    }

    void setCauses(ThrowableDescriptor[] descriptors) {
        this.causes = descriptors;
    }

    void setMessage(String string) {
        this.message = string;
    }

    void setProperties(ThrowablePropertyDescriptor[] descriptors) {
        this.properties = descriptors;
    }

    public void setStackTrace(String[] strings) {
        this.stackTrace = strings;
    }

    void setThrowable(Throwable throwable) {
        this.throwable = throwable;
    }
}

