/*
 * Decompiled with CFR 0.152.
 */
package echopoint.util.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;

public class CapturedPrintWriter
extends PrintWriter {
    private ByteArrayOutputStream out;
    private String characterEncoding;

    public CapturedPrintWriter(ByteArrayOutputStream out, String characterEncoding) {
        super(new StringWriter());
        this.out = out;
        this.characterEncoding = characterEncoding;
    }

    public boolean checkError() {
        return false;
    }

    public void close() {
        try {
            this.out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void flush() {
        try {
            this.out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void print(boolean b) {
        this.print(String.valueOf(b));
    }

    public void print(char c) {
        this.write(c);
    }

    public void print(char[] arr) {
        this.write(arr);
    }

    public void print(double d) {
        this.print(String.valueOf(d));
    }

    public void print(float f) {
        this.print(String.valueOf(f));
    }

    public void print(int i) {
        this.print(String.valueOf(i));
    }

    public void print(long l) {
        this.print(String.valueOf(l));
    }

    public void print(Object obj) {
        this.print(String.valueOf(obj));
    }

    public void print(String s) {
        this.writeBytes(this.toEncodedBytes(s));
    }

    public void println() {
        this.write(10);
    }

    public void println(boolean x) {
        this.println(String.valueOf(x));
    }

    public void println(char x) {
        this.println(String.valueOf(x));
    }

    public void println(char[] x) {
        this.write(x);
        this.write(10);
    }

    public void println(double x) {
        this.println(String.valueOf(x));
    }

    public void println(float x) {
        this.println(String.valueOf(x));
    }

    public void println(int x) {
        this.println(String.valueOf(x));
    }

    public void println(long x) {
        this.println(String.valueOf(x));
    }

    public void println(Object x) {
        this.println(String.valueOf(x));
    }

    public void println(String x) {
        this.println(x.toCharArray());
    }

    protected void setError() {
    }

    public void write(char[] buf, int off, int len) {
        for (int i = off; i < len; ++i) {
            this.write(buf[i]);
        }
    }

    public void write(char[] buf) {
        this.write(buf, 0, buf.length);
    }

    public void write(int c) {
        this.out.write(c);
    }

    public void write(String s, int off, int len) {
        this.writeBytes(this.toEncodedBytes(s), off, len);
    }

    public void write(String s) {
        this.writeBytes(this.toEncodedBytes(s));
    }

    private void writeBytes(byte[] buf) {
        this.writeBytes(buf, 0, buf.length);
    }

    private void writeBytes(byte[] buf, int off, int len) {
        for (int i = 0; i < len; ++i) {
            this.write(buf[i + off]);
        }
    }

    private byte[] toEncodedBytes(String s) {
        if (this.characterEncoding != null) {
            try {
                return s.getBytes(this.characterEncoding);
            }
            catch (UnsupportedEncodingException e) {
                return s.getBytes();
            }
        }
        return s.getBytes();
    }
}

