/*
 * Decompiled with CFR 0.152.
 */
package echopoint.util.io;

import echopoint.util.ReflectionKit;
import echopoint.util.io.CapturedPrintWriter;
import echopoint.util.io.CapturedServletOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

public class CapturedHttpServletResponse
implements HttpServletResponse {
    private HttpServletResponse wrappedResponse;
    private CapturedServletOutputStream noopServletOutputStream;
    private CapturedPrintWriter noopPrintWriter;
    private String contentType;
    private ByteArrayOutputStream out;

    public CapturedHttpServletResponse(HttpServletResponse wrappedResponse, String characterEncoding) {
        this.wrappedResponse = wrappedResponse;
        this.out = new ByteArrayOutputStream();
        this.noopServletOutputStream = new CapturedServletOutputStream(this.out);
        this.noopPrintWriter = new CapturedPrintWriter(this.out, characterEncoding);
        if (characterEncoding != null) {
            this.setCharacterEncoding(characterEncoding);
        }
    }

    public InputStream getCapturedInputStream() {
        byte[] byteArray = this.out.toByteArray();
        ByteArrayInputStream is = new ByteArrayInputStream(byteArray);
        return is;
    }

    public void addCookie(Cookie arg0) {
        this.wrappedResponse.addCookie(arg0);
    }

    public void addDateHeader(String arg0, long arg1) {
        this.wrappedResponse.addDateHeader(arg0, arg1);
    }

    public void addHeader(String arg0, String arg1) {
        this.wrappedResponse.addHeader(arg0, arg1);
    }

    public void addIntHeader(String arg0, int arg1) {
        this.wrappedResponse.addIntHeader(arg0, arg1);
    }

    public boolean containsHeader(String arg0) {
        return this.wrappedResponse.containsHeader(arg0);
    }

    public String encodeRedirectUrl(String arg0) {
        return this.wrappedResponse.encodeRedirectUrl(arg0);
    }

    public String encodeRedirectURL(String arg0) {
        return this.wrappedResponse.encodeRedirectURL(arg0);
    }

    public String encodeUrl(String arg0) {
        return this.wrappedResponse.encodeUrl(arg0);
    }

    public String encodeURL(String arg0) {
        return this.wrappedResponse.encodeURL(arg0);
    }

    public void flushBuffer() throws IOException {
        this.wrappedResponse.flushBuffer();
    }

    public int getBufferSize() {
        return this.wrappedResponse.getBufferSize();
    }

    public String getCharacterEncoding() {
        return this.wrappedResponse.getCharacterEncoding();
    }

    public Locale getLocale() {
        return this.wrappedResponse.getLocale();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.noopServletOutputStream;
    }

    public PrintWriter getWriter() throws IOException {
        return this.noopPrintWriter;
    }

    public int hashCode() {
        return this.wrappedResponse.hashCode();
    }

    public boolean isCommitted() {
        return this.wrappedResponse.isCommitted();
    }

    public void reset() {
        this.wrappedResponse.reset();
    }

    public void resetBuffer() {
        this.wrappedResponse.resetBuffer();
    }

    public void sendError(int arg0) throws IOException {
        this.wrappedResponse.sendError(arg0);
    }

    public void sendError(int arg0, String arg1) throws IOException {
        this.wrappedResponse.sendError(arg0, arg1);
    }

    public void sendRedirect(String arg0) throws IOException {
        this.wrappedResponse.sendRedirect(arg0);
    }

    public void setBufferSize(int arg0) {
        this.wrappedResponse.setBufferSize(arg0);
    }

    public void setContentLength(int arg0) {
        this.wrappedResponse.setContentLength(arg0);
    }

    public void setContentType(String newValue) {
        this.contentType = newValue;
        this.wrappedResponse.setContentType(newValue);
    }

    public void setDateHeader(String arg0, long arg1) {
        this.wrappedResponse.setDateHeader(arg0, arg1);
    }

    public void setHeader(String arg0, String arg1) {
        this.wrappedResponse.setHeader(arg0, arg1);
    }

    public void setIntHeader(String arg0, int arg1) {
        this.wrappedResponse.setIntHeader(arg0, arg1);
    }

    public void setLocale(Locale arg0) {
        this.wrappedResponse.setLocale(arg0);
    }

    public void setStatus(int arg0) {
        this.wrappedResponse.setStatus(arg0);
    }

    public void setStatus(int arg0, String arg1) {
        this.wrappedResponse.setStatus(arg0, arg1);
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setCharacterEncoding(String newValue) {
        ReflectionKit.invokeIfPresent("setCharacterEncoding", new Class[]{String.class}, Void.TYPE, this.wrappedResponse, new Object[]{newValue});
    }
}

