/*
 * Decompiled with CFR 0.152.
 */
package echopoint.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import nextapp.echo.app.util.PropertiesDiscovery;

public class StringPeerFactory {
    private final Map stringToPeerMap = new HashMap();

    public StringPeerFactory(String resourceName, ClassLoader classLoader) {
        try {
            Map peerNameMap = PropertiesDiscovery.loadProperties((String)resourceName, (ClassLoader)classLoader);
            for (String stringValue : peerNameMap.keySet()) {
                String peerClassName = (String)peerNameMap.get(stringValue);
                Class<?> peerClass = classLoader.loadClass(peerClassName);
                Object peer = peerClass.newInstance();
                this.stringToPeerMap.put(stringValue, peer);
            }
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("Unable to load string peer bindings: " + ex);
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to load string peer bindings: " + ex);
        }
        catch (InstantiationException ex) {
            throw new RuntimeException("Unable to load string peer bindings: " + ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("Unable to load string peer bindings: " + ex);
        }
    }

    public Object getPeer(String matchString) {
        Object peer = null;
        peer = this.stringToPeerMap.get(matchString);
        if (peer != null) {
            return peer;
        }
        return null;
    }
}

