/*
 * Decompiled with CFR 0.152.
 */
package echopoint.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

public class ReflectionKit {
    private ReflectionKit() {
    }

    public static boolean isGetter(Method method) {
        if (method == null) {
            return false;
        }
        if (Modifier.isStatic(method.getModifiers())) {
            return false;
        }
        if (method.getReturnType().equals(Void.TYPE)) {
            return false;
        }
        if (method.getParameterTypes().length > 0) {
            return false;
        }
        String name = method.getName();
        if (name.length() > 2 && name.startsWith("is")) {
            return true;
        }
        return name.length() > 3 && name.startsWith("get");
    }

    public static boolean isSetter(Method method) {
        if (method == null) {
            return false;
        }
        if (Modifier.isStatic(method.getModifiers())) {
            return false;
        }
        if (!method.getReturnType().equals(Void.TYPE)) {
            return false;
        }
        if (method.getParameterTypes().length != 1) {
            return false;
        }
        String name = method.getName();
        return name.length() > 3 && name.startsWith("set");
    }

    public static String decapitalize(String name) {
        if (name.startsWith("is")) {
            name = name.substring(2);
        } else if (name.startsWith("get")) {
            name = name.substring(3);
        } else if (name.startsWith("set")) {
            name = name.substring(3);
        }
        if (name == null || name.length() == 0) {
            return name;
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    public static Method[] getMethods(Class targetClass, Class stopClass, MethodSearchCriteria methodSearchCriteria) {
        Method[] methods;
        if (targetClass == null || stopClass == null) {
            return new Method[0];
        }
        if (!stopClass.isAssignableFrom(targetClass)) {
            stopClass = Object.class;
        }
        int methodCount = 0;
        int index = 0;
        Class currentClass = targetClass;
        ArrayList methodList = new ArrayList();
        do {
            methods = currentClass.getDeclaredMethods();
            ArrayList<Method> subMethodList = new ArrayList<Method>();
            if (methods.length <= 0) continue;
            for (int i = 0; i < methods.length; ++i) {
                Method m = methods[i];
                if (!methodSearchCriteria.isMethodOK(currentClass, m)) continue;
                subMethodList.add(m);
                ++methodCount;
            }
            Collections.sort(subMethodList, new ClassMethodComparator());
            Iterator iter = subMethodList.iterator();
            while (iter.hasNext()) {
                methodList.add(iter.next());
            }
        } while (currentClass != stopClass && (currentClass = currentClass.getSuperclass()) != null);
        methods = new Method[methodCount];
        for (Method method : methodList) {
            methods[index++] = method;
        }
        Arrays.sort(methods, new ClassMethodComparator());
        return methods;
    }

    public static Method[] getAllDeclaredMethods(Class targetClass, Class stopClass) {
        return ReflectionKit.getMethods(targetClass, stopClass, new MethodSearchCriteria(){

            public boolean isMethodOK(Class methodClass, Method method) {
                return true;
            }
        });
    }

    public static Method[] getAllDeclaredMethods(Class targetClass) {
        return ReflectionKit.getAllDeclaredMethods(targetClass, Object.class);
    }

    public static Method[] getAllPublicMethods(Class targetClass, Class stopClass) {
        return ReflectionKit.getMethods(targetClass, stopClass, new MethodSearchCriteria(){

            public boolean isMethodOK(Class methodClass, Method method) {
                return Modifier.isPublic(method.getModifiers());
            }
        });
    }

    public static Method[] getAllBeanGetterMethods(Class targetClass, Class stopClass) {
        Method[] methods = ReflectionKit.getMethods(targetClass, stopClass, new MethodSearchCriteria(){

            public boolean isMethodOK(Class methodClass, Method method) {
                return ReflectionKit.isGetter(method);
            }
        });
        Arrays.sort(methods, new ClassMethodComparator());
        return methods;
    }

    public static Method[] getAllBeanSetterMethods(Class targetClass, Class stopClass) {
        Method[] methods = ReflectionKit.getMethods(targetClass, stopClass, new MethodSearchCriteria(){

            public boolean isMethodOK(Class methodClass, Method method) {
                return ReflectionKit.isSetter(method);
            }
        });
        Arrays.sort(methods, new ClassMethodComparator());
        return methods;
    }

    public static Method[] getAllBeanMethods(Class targetClass, Class stopClass) {
        Method[] methods = ReflectionKit.getMethods(targetClass, stopClass, new MethodSearchCriteria(){

            public boolean isMethodOK(Class methodClass, Method method) {
                return ReflectionKit.isSetter(method) || ReflectionKit.isGetter(method);
            }
        });
        Arrays.sort(methods, new MethodClassComparator());
        return methods;
    }

    public static Method getBeanGetter(Method beanSetter) {
        if (beanSetter == null) {
            throw new IllegalArgumentException("beanSetter must be non null");
        }
        String setterName = ReflectionKit.decapitalize(beanSetter.getName());
        Class<?> setterType = beanSetter.getParameterTypes()[0];
        Method[] getters = ReflectionKit.getAllBeanGetterMethods(beanSetter.getDeclaringClass(), Object.class);
        for (int i = 0; i < getters.length; ++i) {
            Method getter = getters[i];
            String getterName = ReflectionKit.decapitalize(getter.getName());
            if (!getterName.equals(setterName) || !getter.getReturnType().equals(setterType)) continue;
            return getter;
        }
        return null;
    }

    public static Class[] getClassHierarchy(Class targetClass) {
        return ReflectionKit.getClassHierarchy(targetClass, Object.class);
    }

    public static Class[] getClassHierarchy(Class targetClass, Class stopClass) {
        if (targetClass == null || stopClass == null) {
            return new Class[0];
        }
        if (targetClass == stopClass) {
            return new Class[]{targetClass};
        }
        if (!stopClass.isAssignableFrom(targetClass)) {
            stopClass = Object.class;
        }
        ArrayList list = new ArrayList();
        list.add(targetClass);
        do {
            if ((targetClass = targetClass.getSuperclass()) == null) continue;
            list.add(targetClass);
        } while (!targetClass.equals(stopClass) && targetClass != null);
        return list.toArray(new Class[list.size()]);
    }

    public static boolean hasMethod(String methodName, Class[] paramTypes, Class returnType, Object targetObj) {
        if (targetObj == null) {
            throw new IllegalArgumentException("You must provide a target Object!");
        }
        if (paramTypes == null) {
            paramTypes = new Class[]{};
        }
        if (returnType == null) {
            returnType = Void.TYPE;
        }
        final String testMethodName = methodName;
        final Class[] testParamTypes = paramTypes;
        final Class<Void> testReturnType = returnType;
        Method[] methods = ReflectionKit.getMethods(targetObj.getClass(), Object.class, new MethodSearchCriteria(){

            public boolean isMethodOK(Class methodClass, Method method) {
                Class<?>[] paramTypes;
                if (method.getName().equals(testMethodName) && method.getReturnType().equals(testReturnType) && (paramTypes = method.getParameterTypes()).length == testParamTypes.length) {
                    for (int i = 0; i < paramTypes.length; ++i) {
                        if (testParamTypes[i].equals(paramTypes[i])) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
        });
        return methods.length > 0;
    }

    public static Object invokeIfPresent(String methodName, Class[] paramTypes, Class returnType, Object targetObj, Object[] params) {
        if (targetObj == null) {
            throw new IllegalArgumentException("You must provide a target Object!");
        }
        if (paramTypes == null) {
            paramTypes = new Class[]{};
        }
        if (params == null) {
            params = new Object[]{};
        }
        if (returnType == null) {
            returnType = Void.TYPE;
        }
        final String testMethodName = methodName;
        final Class[] testParamTypes = paramTypes;
        final Class<Void> testReturnType = returnType;
        Method[] methods = ReflectionKit.getMethods(targetObj.getClass(), Object.class, new MethodSearchCriteria(){

            public boolean isMethodOK(Class methodClass, Method method) {
                Class<?>[] paramTypes;
                if (method.getName().equals(testMethodName) && method.getReturnType().equals(testReturnType) && (paramTypes = method.getParameterTypes()).length == testParamTypes.length) {
                    for (int i = 0; i < paramTypes.length; ++i) {
                        if (testParamTypes[i].equals(paramTypes[i])) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
        });
        if (methods.length > 0) {
            try {
                return methods[0].invoke(targetObj, params);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static interface MethodSearchCriteria {
        public boolean isMethodOK(Class var1, Method var2);
    }

    public static class ClassConstructorComparator
    extends ClassMemberComparator {
    }

    public static class ClassFieldComparator
    extends ClassMemberComparator {
    }

    public static class FieldClassComparator
    extends MemberClassComparator {
    }

    public static class ClassMethodComparator
    extends ClassMemberComparator {
    }

    public static class MethodClassComparator
    extends MemberClassComparator {
    }

    public static class ClassMemberComparator
    extends MemberClassComparator {
        public int compare(Object o1, Object o2) {
            Class<?> c2;
            if (o1 == null || o2 == null) {
                return this.compareForNullness(o1, o2);
            }
            Member m1 = (Member)o1;
            Member m2 = (Member)o2;
            Class<?> c1 = m1.getDeclaringClass();
            if (c1.equals(c2 = m2.getDeclaringClass())) {
                int rc = this.compareByModifiers(m1.getModifiers(), m2.getModifiers());
                if (rc == 0) {
                    if (m1 instanceof Method && m2 instanceof Method) {
                        rc = this.compareByMethod((Method)m1, (Method)m2);
                    }
                    if (m1 instanceof Field && m2 instanceof Field) {
                        rc = this.compareByField((Field)m1, (Field)m2);
                    }
                    if (m1 instanceof Constructor && m2 instanceof Constructor) {
                        rc = this.compareByConstructor((Constructor)m1, (Constructor)m2);
                    }
                }
                return this.normaliseRC(rc);
            }
            return this.compareByClassDerivation(c1, c2);
        }
    }

    public static class MemberClassComparator
    extends BaseReflectionKitComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            if (o1 == null || o2 == null) {
                return this.compareForNullness(o1, o2);
            }
            Member m1 = (Member)o1;
            Member m2 = (Member)o2;
            int rc = this.compareByModifiers(m1.getModifiers(), m2.getModifiers());
            if (rc == 0) {
                if (m1 instanceof Method && m2 instanceof Method) {
                    rc = this.compareByMethod((Method)m1, (Method)m2);
                }
                if (m1 instanceof Field && m2 instanceof Field) {
                    rc = this.compareByField((Field)m1, (Field)m2);
                }
                if (m1 instanceof Constructor && m2 instanceof Constructor) {
                    rc = this.compareByConstructor((Constructor)m1, (Constructor)m2);
                }
            }
            if (rc == 0) {
                rc = this.compareByClassDerivation(m1.getDeclaringClass(), m2.getDeclaringClass());
            }
            return this.normaliseRC(rc);
        }

        protected int compareByModifiers(int modifier1, int modifier2) {
            int[] weights = new int[2];
            int[] modifiers = new int[]{modifier1, modifier2};
            for (int i = 0; i < modifiers.length; ++i) {
                int mod = modifiers[i];
                if (Modifier.isPublic(mod)) {
                    int n = i;
                    weights[n] = weights[n] | 0x10000000;
                }
                if (Modifier.isProtected(mod)) {
                    int n = i;
                    weights[n] = weights[n] | 0x1000000;
                }
                if (Modifier.isProtected(mod)) {
                    int n = i;
                    weights[n] = weights[n] | 0x100000;
                }
                if (Modifier.isAbstract(mod)) {
                    int n = i;
                    weights[n] = weights[n] | 0x10000;
                }
                if (Modifier.isFinal(mod)) {
                    int n = i;
                    weights[n] = weights[n] | 0x1000;
                }
                if (Modifier.isNative(mod)) {
                    int n = i;
                    weights[n] = weights[n] | 0x100;
                }
                if (Modifier.isInterface(mod)) {
                    int n = i;
                    weights[n] = weights[n] | 0x10000010;
                }
                if (!Modifier.isStatic(mod)) continue;
                int n = i;
                weights[n] = weights[n] | 1;
            }
            int rc = weights[0] - weights[1];
            return this.normaliseRC(rc);
        }

        protected int compareByMethod(Method m1, Method m2) {
            Class<?>[] m2ParamTypes;
            Class<?>[] m1ParamTypes;
            int rc = m1.getName().compareTo(m2.getName());
            if (rc == 0 && (rc = this.compareByClassDerivation(m1.getReturnType(), m1.getReturnType())) == 0 && (rc = (m1ParamTypes = m1.getParameterTypes()).length - (m2ParamTypes = m2.getParameterTypes()).length) == 0) {
                for (int i = 0; i < m1ParamTypes.length && (rc = this.compareByClassDerivation(m1ParamTypes[i], m1ParamTypes[i])) != 0; ++i) {
                }
            }
            return this.normaliseRC(rc);
        }

        protected int compareByField(Field f1, Field f2) {
            if (f1 == null || f2 == null) {
                return this.compareForNullness(f1, f2);
            }
            int rc = f1.getName().compareTo(f2.getName());
            if (rc == 0) {
                rc = this.compareByClassDerivation(f1.getType(), f1.getType());
            }
            return this.normaliseRC(rc);
        }

        protected int compareByConstructor(Constructor c1, Constructor c2) {
            Class<?>[] c2ParamTypes;
            if (c1 == null || c2 == null) {
                return this.compareForNullness(c1, c2);
            }
            Class<?>[] c1ParamTypes = c1.getParameterTypes();
            int rc = c1ParamTypes.length - (c2ParamTypes = c2.getParameterTypes()).length;
            if (rc == 0) {
                for (int i = 0; i < c1ParamTypes.length && (rc = this.compareByClassDerivation(c1ParamTypes[i], c1ParamTypes[i])) != 0; ++i) {
                }
            }
            return this.normaliseRC(rc);
        }
    }

    public static class ClassDerivationComparator
    extends BaseReflectionKitComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            if (o1 == null || o2 == null) {
                return this.compareForNullness(o1, o2);
            }
            return this.compareByClassDerivation((Class)o1, (Class)o2);
        }
    }

    public static class ClassNameComparator
    extends BaseReflectionKitComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            if (o1 == null || o2 == null) {
                return this.compareForNullness(o1, o2);
            }
            Class c1 = (Class)o1;
            Class c2 = (Class)o2;
            int rc = c1.getName().compareTo(c2.getName());
            return this.normaliseRC(rc);
        }
    }

    private static abstract class BaseReflectionKitComparator
    implements Comparator {
        private BaseReflectionKitComparator() {
        }

        int compareForNullness(Object o1, Object o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null && o2 != null) {
                return -1;
            }
            if (o1 != null && o2 == null) {
                return 1;
            }
            return Integer.MAX_VALUE;
        }

        protected int normaliseRC(int rc) {
            if (rc < 0) {
                return -1;
            }
            if (rc > 0) {
                return 1;
            }
            return 0;
        }

        protected int compareByClassDerivation(Class c1, Class c2) {
            if (c1 == null || c2 == null) {
                return this.compareForNullness(c1, c2);
            }
            if (c1.equals(c2)) {
                return 0;
            }
            if (c2.isAssignableFrom(c1) || c1.isAssignableFrom(c2)) {
                if (c2.isAssignableFrom(c1)) {
                    return -1;
                }
                if (c1.isAssignableFrom(c2)) {
                    return 1;
                }
            }
            int rc = c1.getName().compareTo(c2.getName());
            return this.normaliseRC(rc);
        }
    }
}

