/*
 * Decompiled with CFR 0.152.
 */
package echopoint.util;

import java.util.Calendar;
import java.util.List;
import java.util.Random;

public class RandKit {
    private static Random rn = new Random();

    private RandKit() {
    }

    public static double rand(double lo, double hi) {
        if (lo > hi) {
            double save = lo;
            lo = hi;
            hi = save;
        }
        double range = hi - lo + 1.0;
        double frac = range * rn.nextDouble();
        return frac + lo;
    }

    public static int rand(int lo, int hi) {
        return (int)RandKit.rand((long)lo, (long)hi);
    }

    public static long rand(long lo, long hi) {
        if (lo > hi) {
            long save = lo;
            lo = hi;
            hi = save;
        }
        long range = hi - lo + 1L;
        long frac = (long)((double)range * rn.nextDouble());
        return frac + lo;
    }

    public static Calendar rand(Calendar start, Calendar end) {
        if (start.after(end)) {
            Calendar temp = start;
            start = end;
            end = temp;
        }
        long diff = end.getTime().getTime() - start.getTime().getTime();
        long daysDiff = diff / 86400000L;
        int delta = RandKit.rand(0, (int)daysDiff);
        Calendar newCal = Calendar.getInstance();
        newCal.setTime(start.getTime());
        newCal.setTimeZone(start.getTimeZone());
        newCal.add(5, delta);
        newCal.add(10, RandKit.rand(0, 23));
        newCal.add(12, RandKit.rand(0, 59));
        newCal.add(13, RandKit.rand(0, 59));
        if (newCal.after(end)) {
            newCal.setTime(end.getTime());
            newCal.setTimeZone(end.getTimeZone());
        }
        if (newCal.before(start)) {
            newCal.setTime(start.getTime());
            newCal.setTimeZone(start.getTimeZone());
        }
        return newCal;
    }

    public static char roll(char[] chars) {
        int index = RandKit.rand(0, chars.length - 1);
        return chars[index];
    }

    public static double roll(double[] doubles) {
        int index = RandKit.rand(0, doubles.length - 1);
        return doubles[index];
    }

    public static float roll(float[] floats) {
        int index = RandKit.rand(0, floats.length - 1);
        return floats[index];
    }

    public static int roll(int[] ints) {
        int index = RandKit.rand(0, ints.length - 1);
        return ints[index];
    }

    public static long roll(long[] longs) {
        int index = RandKit.rand(0, longs.length - 1);
        return longs[index];
    }

    public static Object roll(Object[] arr) {
        int index = RandKit.rand(0, arr.length - 1);
        return arr[index];
    }

    public static String roll(String[] arrStrings) {
        int index = RandKit.rand(0, arrStrings.length - 1);
        return arrStrings[index];
    }

    public static boolean roll(boolean[] booleans) {
        int index = RandKit.rand(0, booleans.length - 1);
        return booleans[index];
    }

    public static boolean roll(int percentageChance) {
        int val = RandKit.rand(0, 100);
        if (percentageChance > 100) {
            percentageChance = 100;
        }
        if (percentageChance < 0) {
            percentageChance = 0;
        }
        return val >= percentageChance;
    }

    public static Object roll(List list) {
        int index = RandKit.rand(0, list.size() - 1);
        return list.get(index);
    }

    public static boolean roll5050() {
        return RandKit.rand(0, 100001) > 50000;
    }

    public static Object[] rand(Object[] possibles, Object[] destination) {
        if (possibles == null || destination == null) {
            return destination;
        }
        int maxTimes = Math.min(possibles.length, destination.length);
        int index = 0;
        int count = 0;
        do {
            ++count;
            if (index >= maxTimes) break;
            Object choice = RandKit.roll(possibles);
            boolean found = false;
            for (int j = 0; j < destination.length; ++j) {
                if (choice != destination[j]) continue;
                found = true;
                break;
            }
            if (found) continue;
            destination[index] = choice;
            ++index;
        } while (count <= maxTimes * 100);
        return destination;
    }
}

