/*
 * Decompiled with CFR 0.152.
 */
package echopoint.util;

import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class HtmlKit {
    public static final int NEWLINE_REMOVE = 3;
    public static final int NEWLINE_TO_BR = 2;
    public static final int NEWLINE_TO_SPACE = 1;
    public static final int NEWLINE_TRANSPARENT = 0;

    public static String encode(String text) {
        return HtmlKit.encode(text, 0);
    }

    public static String encode(String text, int newLinePolicy) {
        StringBuffer sb = new StringBuffer();
        String quot = "&quot;";
        String amp = "&amp;";
        String lt = "&lt;";
        String gt = "&gt;";
        String nbsp = "&nbsp;";
        if (text != null) {
            int index;
            int length = text.length();
            int startIndex = 0;
            block12: for (index = 0; index < length; ++index) {
                switch (text.charAt(index)) {
                    case ' ': {
                        if (index == 0 || index == length - 1) {
                            if (startIndex < index) {
                                sb.append(text.substring(startIndex, index));
                            }
                            sb.append("&nbsp;");
                            startIndex = index + 1;
                            continue block12;
                        }
                        if (index >= length - 1 || text.charAt(index + 1) != ' ') continue block12;
                        if (startIndex < index) {
                            sb.append(text.substring(startIndex, index));
                        }
                        if (index < length - 3 && text.charAt(index + 2) == ' ' && text.charAt(index + 3) != ' ') {
                            sb.append("&nbsp;");
                            sb.append("&nbsp;");
                            sb.append(" ");
                            index += 2;
                        } else {
                            sb.append("&nbsp;");
                            sb.append(" ");
                            ++index;
                        }
                        startIndex = index + 1;
                        continue block12;
                    }
                    case '\n': 
                    case '\r': {
                        if (newLinePolicy == 0) continue block12;
                        if (startIndex < index) {
                            sb.append(text.substring(startIndex, index));
                        }
                        if (index < length - 1 && (text.charAt(index) == '\r' && text.charAt(index + 1) == '\n' || text.charAt(index) == '\n' && text.charAt(index + 1) == '\r')) {
                            ++index;
                        }
                        switch (newLinePolicy) {
                            case 1: {
                                sb.append(" ");
                                break;
                            }
                            case 2: {
                                sb.append("<br/>\n");
                            }
                        }
                        startIndex = index + 1;
                        continue block12;
                    }
                    case '<': {
                        if (startIndex < index) {
                            sb.append(text.substring(startIndex, index));
                        }
                        sb.append("&lt;");
                        startIndex = index + 1;
                        continue block12;
                    }
                    case '>': {
                        if (startIndex < index) {
                            sb.append(text.substring(startIndex, index));
                        }
                        sb.append("&gt;");
                        startIndex = index + 1;
                        continue block12;
                    }
                    case '\"': {
                        if (startIndex < index) {
                            sb.append(text.substring(startIndex, index));
                        }
                        sb.append("&quot;");
                        startIndex = index + 1;
                        continue block12;
                    }
                    case '&': {
                        if (startIndex < index) {
                            sb.append(text.substring(startIndex, index));
                        }
                        sb.append("&amp;");
                        startIndex = index + 1;
                    }
                }
            }
            if (startIndex < index) {
                sb.append(text.substring(startIndex));
            }
        }
        return sb.toString();
    }

    public static Node[] encodeNewLines(Document document, String text, int newLinePolicy) {
        Node node;
        int index;
        ArrayList<Text> nodeList = new ArrayList<Text>();
        StringBuffer sb = new StringBuffer();
        int length = text.length();
        int startIndex = 0;
        block7: for (index = 0; index < length; ++index) {
            switch (text.charAt(index)) {
                case '\n': 
                case '\r': {
                    if (newLinePolicy == 0) continue block7;
                    if (startIndex < index) {
                        sb.append(text.substring(startIndex, index));
                    }
                    if (index < length - 1 && (text.charAt(index) == '\r' && text.charAt(index + 1) == '\n' || text.charAt(index) == '\n' && text.charAt(index + 1) == '\r')) {
                        ++index;
                    }
                    switch (newLinePolicy) {
                        case 1: {
                            sb.append(" ");
                            break;
                        }
                        case 2: {
                            node = document.createTextNode(sb.toString());
                            nodeList.add((Text)node);
                            node = document.createElement("br");
                            nodeList.add((Text)node);
                            sb.setLength(0);
                        }
                    }
                    startIndex = index + 1;
                }
            }
        }
        if (startIndex < index) {
            sb.append(text.substring(startIndex));
            node = document.createTextNode(sb.toString());
            nodeList.add((Text)node);
        }
        return nodeList.toArray(new Node[nodeList.size()]);
    }

    private HtmlKit() {
    }
}

