/*
 * Decompiled with CFR 0.152.
 */
package echopoint.util;

import nextapp.echo.app.Extent;

public class ExtentKit {
    public static Extent makeExtent(String extentString) {
        if (extentString == null) {
            throw new IllegalArgumentException("The extentString must be non null");
        }
        if (!ExtentKit.isExtent(extentString)) {
            throw new IllegalArgumentException("The extentString is invalid : " + extentString);
        }
        extentString = extentString.trim().toLowerCase();
        String digitBit = ExtentKit._parseIntegerPrefix(extentString);
        String unitBit = ExtentKit._parseIntegerPostfix(extentString);
        int size = Integer.parseInt(digitBit);
        int units = 1;
        if (unitBit.equals("px")) {
            units = 1;
        } else if (unitBit.equals("%")) {
            units = 2;
        } else if (unitBit.equals("pt")) {
            units = 4;
        } else if (unitBit.equals("cm")) {
            units = 8;
        } else if (unitBit.equals("mm")) {
            units = 16;
        } else if (unitBit.equals("in")) {
            units = 32;
        } else if (unitBit.equals("em")) {
            units = 64;
        } else if (unitBit.equals("ex")) {
            units = 128;
        } else if (unitBit.equals("pc")) {
            units = 256;
        }
        return new Extent(size, units);
    }

    public static boolean isExtent(String extentString) {
        if (extentString == null) {
            return false;
        }
        extentString = extentString.trim().toLowerCase();
        String digitBit = ExtentKit._parseIntegerPrefix(extentString);
        String unitBit = ExtentKit._parseIntegerPostfix(extentString);
        if (!ExtentKit._isInteger(digitBit)) {
            return false;
        }
        return ExtentKit._isExtentUnit(unitBit);
    }

    private static boolean _isExtentUnit(String propertyValue) {
        if (propertyValue.equals("px")) {
            return true;
        }
        if (propertyValue.equals("%")) {
            return true;
        }
        if (propertyValue.equals("pt")) {
            return true;
        }
        if (propertyValue.equals("cm")) {
            return true;
        }
        if (propertyValue.equals("mm")) {
            return true;
        }
        if (propertyValue.equals("in")) {
            return true;
        }
        if (propertyValue.equals("em")) {
            return true;
        }
        if (propertyValue.equals("ex")) {
            return true;
        }
        return propertyValue.equals("pc");
    }

    private static boolean _isInteger(String propertyValue) {
        try {
            Integer.parseInt(propertyValue.trim());
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    private static String _parseIntegerPrefix(String propertyValue) {
        int i;
        for (i = 0; i < propertyValue.length() && Character.isDigit(propertyValue.charAt(i)); ++i) {
        }
        return propertyValue.substring(0, i);
    }

    private static String _parseIntegerPostfix(String propertyValue) {
        int i;
        for (i = 0; i < propertyValue.length() && Character.isDigit(propertyValue.charAt(i)); ++i) {
        }
        return propertyValue.substring(i, propertyValue.length());
    }
}

