/*
 * Decompiled with CFR 0.152.
 */
package echopoint.util;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import nextapp.echo.app.Component;

public class ComponentTracker
implements Serializable {
    Map componentMap;
    Component trackee;

    public ComponentTracker(Component trackeeComponent) {
        this.trackee = trackeeComponent;
    }

    public void add(Component child) {
        this.add(child, -1);
    }

    public void add(Component child, int index) {
        if (this.componentMap == null) {
            this.componentMap = new HashMap();
        }
        this.componentMap.put(child, child);
        this.trackee.add(child, index);
    }

    public void remove(Component child) {
        if (this.componentMap != null) {
            this.componentMap.remove(child);
        }
        this.trackee.remove(child);
    }

    public void remove(int index) {
        Component child = this.trackee.getComponent(index);
        if (this.componentMap != null) {
            this.componentMap.remove(child);
        }
        this.trackee.remove(index);
    }

    public void removeAll() {
        if (this.componentMap != null) {
            Iterator iter = this.componentMap.keySet().iterator();
            while (iter.hasNext()) {
                Component child = (Component)iter.next();
                this.trackee.remove(child);
                iter.remove();
            }
        }
    }

    public Component[] getComponents() {
        if (this.componentMap == null) {
            return new Component[0];
        }
        Component[] children = new Component[this.componentMap.size()];
        int i = 0;
        Iterator iter = this.componentMap.keySet().iterator();
        while (iter.hasNext()) {
            Component child;
            children[i] = child = (Component)iter.next();
            ++i;
        }
        return children;
    }

    public int getComponentCount() {
        if (this.componentMap == null) {
            return 0;
        }
        return this.componentMap.size();
    }
}

