/*
 * Decompiled with CFR 0.152.
 */
package echopoint.util;

import echopoint.util.TokenizerKit;
import echopoint.util.collections.ConcurrentReaderHashMap;
import java.awt.Color;
import java.util.Map;
import nextapp.echo.app.Component;

public class ColorKit {
    public static String[] ColorConstantStrings = new String[]{"Color.BLACK", "BLACK", "Color.BLUE", "BLUE", "Color.CYAN", "CYAN", "Color.DARKGRAY", "DARKGRAY", "Color.GREEN", "GREEN", "Color.LIGHTGRAY", "LIGHTGRAY", "Color.MAGENTA", "MAGENTA", "Color.ORANGE", "ORANGE", "Color.PINK", "PINK", "Color.RED", "RED", "Color.WHITE", "WHITE", "Color.YELLOW", "YELLOW"};
    public static nextapp.echo.app.Color[] ColorConstantValues = new nextapp.echo.app.Color[]{nextapp.echo.app.Color.BLACK, nextapp.echo.app.Color.BLACK, nextapp.echo.app.Color.BLUE, nextapp.echo.app.Color.BLUE, nextapp.echo.app.Color.CYAN, nextapp.echo.app.Color.CYAN, nextapp.echo.app.Color.DARKGRAY, nextapp.echo.app.Color.DARKGRAY, nextapp.echo.app.Color.GREEN, nextapp.echo.app.Color.GREEN, nextapp.echo.app.Color.LIGHTGRAY, nextapp.echo.app.Color.LIGHTGRAY, nextapp.echo.app.Color.MAGENTA, nextapp.echo.app.Color.MAGENTA, nextapp.echo.app.Color.ORANGE, nextapp.echo.app.Color.ORANGE, nextapp.echo.app.Color.PINK, nextapp.echo.app.Color.PINK, nextapp.echo.app.Color.RED, nextapp.echo.app.Color.RED, nextapp.echo.app.Color.WHITE, nextapp.echo.app.Color.WHITE, nextapp.echo.app.Color.YELLOW, nextapp.echo.app.Color.YELLOW};
    public static final double COLOR_FACTOR = 0.7;
    private static Map colorMap = new ConcurrentReaderHashMap();
    public static final int SWAP_OP_BGR = 0;
    public static final int SWAP_OP_BRG = 1;
    public static final int SWAP_OP_GBR = 2;
    public static final int SWAP_OP_GRB = 3;
    public static final int SWAP_OP_RBG = 4;

    private ColorKit() {
    }

    private static nextapp.echo.app.Color _parseHashHexString(String hasHexString) {
        StringBuffer sb = new StringBuffer(hasHexString.substring(1));
        while (sb.length() < 6) {
            sb.append("0");
        }
        String hex = sb.substring(0, 6);
        int rgb = Integer.parseInt(hex, 16);
        return new nextapp.echo.app.Color(rgb);
    }

    private static String _toHexString(int i) {
        String hex = Integer.toHexString(i);
        if (hex.length() < 2) {
            hex = "0" + hex;
        }
        return hex.toUpperCase();
    }

    private static boolean _isInteger(String propertyValue) {
        try {
            Integer.parseInt(propertyValue.trim());
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    private static boolean _isHexInteger(String propertyValue) {
        if ((propertyValue = propertyValue.trim().toLowerCase()).indexOf("0x") == 0) {
            propertyValue = propertyValue.substring(2);
        }
        try {
            Integer.parseInt(propertyValue, 16);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    private static int _arrayIndexOf(String s, String[] array) {
        if (array == null) {
            return -1;
        }
        for (int i = 0; i < array.length; ++i) {
            if (!s.equalsIgnoreCase(array[i])) continue;
            return i;
        }
        return -1;
    }

    public static nextapp.echo.app.Color brighter(nextapp.echo.app.Color color) {
        return ColorKit.brighter(color, 0.7);
    }

    public static nextapp.echo.app.Color brighter(nextapp.echo.app.Color color, double factor) {
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        int i = (int)(1.0 / (1.0 - factor));
        if (r == 0 && g == 0 && b == 0) {
            return new nextapp.echo.app.Color(i, i, i);
        }
        if (r > 0 && r < i) {
            r = i;
        }
        if (g > 0 && g < i) {
            g = i;
        }
        if (b > 0 && b < i) {
            b = i;
        }
        return ColorKit.makeColor(Math.min((int)((double)r / factor), 255), Math.min((int)((double)g / factor), 255), Math.min((int)((double)b / factor), 255));
    }

    public static nextapp.echo.app.Color darker(nextapp.echo.app.Color color) {
        return ColorKit.darker(color, 0.7);
    }

    public static nextapp.echo.app.Color darker(nextapp.echo.app.Color color, double factor) {
        return ColorKit.makeColor(Math.max((int)((double)color.getRed() * factor), 0), Math.max((int)((double)color.getGreen() * factor), 0), Math.max((int)((double)color.getBlue() * factor), 0));
    }

    public static nextapp.echo.app.Color findBackground(Component comp) {
        while (comp != null) {
            nextapp.echo.app.Color clr = comp.getBackground();
            if (clr != null) {
                return clr;
            }
            comp = comp.getParent();
        }
        return nextapp.echo.app.Color.WHITE;
    }

    public static nextapp.echo.app.Color findForeground(Component comp) {
        while (comp != null) {
            nextapp.echo.app.Color clr = comp.getForeground();
            if (clr != null) {
                return clr;
            }
            comp = comp.getParent();
        }
        return nextapp.echo.app.Color.BLACK;
    }

    public static nextapp.echo.app.Color invertColor(nextapp.echo.app.Color color) {
        int r = Math.abs(255 - color.getRed());
        int g = Math.abs(255 - color.getGreen());
        int b = Math.abs(255 - color.getBlue());
        return ColorKit.makeColor(r, g, b);
    }

    public static Color makeAwtColor(nextapp.echo.app.Color echoColor, Color defaultAwtColor) {
        if (echoColor == null) {
            return defaultAwtColor;
        }
        return new Color(echoColor.getRgb(), false);
    }

    public static String makeCSSColor(nextapp.echo.app.Color color) {
        StringBuffer b = new StringBuffer();
        b.append("#");
        b.append(ColorKit.makeHexColor(color));
        return b.toString().toUpperCase();
    }

    public static String makeColorString(nextapp.echo.app.Color color) {
        StringBuffer b = new StringBuffer();
        b.append("color(");
        b.append(color.getRed());
        b.append(",");
        b.append(color.getGreen());
        b.append(",");
        b.append(color.getBlue());
        b.append(")");
        return b.toString();
    }

    public static String makeHexColor(nextapp.echo.app.Color color) {
        StringBuffer b = new StringBuffer();
        b.append(ColorKit._toHexString(color.getRed()));
        b.append(ColorKit._toHexString(color.getGreen()));
        b.append(ColorKit._toHexString(color.getBlue()));
        return b.toString().toLowerCase();
    }

    public static nextapp.echo.app.Color makeColor(String colorString) {
        int index;
        if (colorString == null) {
            throw new IllegalArgumentException("Illegal null color string");
        }
        nextapp.echo.app.Color color = (nextapp.echo.app.Color)colorMap.get(colorString = colorString.trim().toLowerCase());
        if (color != null) {
            return color;
        }
        if (!ColorKit.isColor(colorString)) {
            throw new IllegalArgumentException("Illegal color string" + colorString);
        }
        String[] tokens = TokenizerKit.tokenize(colorString, "(,)");
        if (tokens.length == 1 && (index = ColorKit._arrayIndexOf(colorString, ColorConstantStrings)) != -1) {
            color = ColorConstantValues[index];
        }
        if (color == null) {
            if (colorString.indexOf(35) == 0) {
                color = ColorKit._parseHashHexString(colorString);
            } else {
                int r = Integer.parseInt(tokens[1].trim());
                int g = Integer.parseInt(tokens[2].trim());
                int b = Integer.parseInt(tokens[3].trim());
                color = new nextapp.echo.app.Color(r, g, b);
            }
        }
        colorMap.put(colorString, color);
        return color;
    }

    public static boolean isColor(String colorString) {
        if (colorString == null) {
            return false;
        }
        String[] tokens = TokenizerKit.tokenize(colorString = colorString.trim(), "(,)");
        if (tokens.length == 1 && ColorKit._arrayIndexOf(colorString, ColorConstantStrings) != -1) {
            return true;
        }
        if (colorString.indexOf(35) == 0) {
            return ColorKit._isHexInteger(colorString.substring(1).trim());
        }
        if (colorString.indexOf("rgb(") == 0 || colorString.indexOf("color(") == 0) {
            if (tokens.length != 4) {
                return false;
            }
            String r = tokens[1].trim();
            String g = tokens[2].trim();
            String b = tokens[3].trim();
            return ColorKit._isInteger(r) && ColorKit._isInteger(g) && ColorKit._isInteger(b);
        }
        return false;
    }

    public static nextapp.echo.app.Color clr(String colorString) {
        return ColorKit.makeColor(colorString);
    }

    public static nextapp.echo.app.Color clr(int r, int g, int b) {
        return ColorKit.makeColor(r, g, b);
    }

    public static nextapp.echo.app.Color clr(int rgb) {
        return ColorKit.makeColor(rgb);
    }

    public static nextapp.echo.app.Color makeColor(int r, int g, int b) {
        StringBuffer buf = new StringBuffer();
        buf.append('#');
        buf.append(ColorKit._toHexString(r));
        buf.append(ColorKit._toHexString(g));
        buf.append(ColorKit._toHexString(b));
        String colorString = buf.toString().toLowerCase();
        nextapp.echo.app.Color color = (nextapp.echo.app.Color)colorMap.get(colorString);
        if (color == null) {
            color = new nextapp.echo.app.Color(r, g, b);
            colorMap.put(colorString, color);
        }
        return color;
    }

    public static nextapp.echo.app.Color makeColor(int rgb) {
        StringBuffer buf = new StringBuffer();
        buf.append('#');
        buf.append(ColorKit._toHexString(rgb));
        String colorString = buf.toString().toLowerCase();
        nextapp.echo.app.Color color = (nextapp.echo.app.Color)colorMap.get(colorString);
        if (color == null) {
            color = new nextapp.echo.app.Color(rgb);
            colorMap.put(colorString, color);
        }
        return color;
    }

    public static nextapp.echo.app.Color tint(nextapp.echo.app.Color clr, double red, double green, double blue) {
        double newRed = (double)clr.getRed() * red;
        double newGreen = (double)clr.getGreen() * green;
        double newBlue = (double)clr.getBlue() * blue;
        double normFactor = Math.max(newRed, Math.max(newGreen, newBlue)) / 255.0;
        return ColorKit.makeColor((int)(newRed /= normFactor), (int)(newGreen /= normFactor), (int)(newBlue /= normFactor));
    }

    public static nextapp.echo.app.Color swapRGB(nextapp.echo.app.Color swapColor, int swapOperation) {
        if (swapColor == null) {
            return swapColor;
        }
        int r = swapColor.getRed();
        int g = swapColor.getGreen();
        int b = swapColor.getBlue();
        switch (swapOperation) {
            case 4: {
                return ColorKit.makeColor(r, b, g);
            }
            case 0: {
                return ColorKit.makeColor(b, g, r);
            }
            case 1: {
                return ColorKit.makeColor(b, r, g);
            }
            case 2: {
                return ColorKit.makeColor(g, b, r);
            }
            case 3: {
                return ColorKit.makeColor(g, r, b);
            }
        }
        return swapColor;
    }
}

