/*
 * Decompiled with CFR 0.152.
 */
package echopoint.tucana.event;

import echopoint.tucana.FileUploadSelector;
import echopoint.tucana.event.InvalidContentTypeEvent;
import echopoint.tucana.event.UploadCallback;
import echopoint.tucana.event.UploadCancelEvent;
import echopoint.tucana.event.UploadEvent;
import echopoint.tucana.event.UploadFailEvent;
import echopoint.tucana.event.UploadFinishEvent;
import echopoint.tucana.event.UploadProgressEvent;
import echopoint.tucana.event.UploadStartEvent;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UploadCallbackAdapter
implements UploadCallback {
    private static final long serialVersionUID = 1L;
    protected static final Logger logger = Logger.getAnonymousLogger();
    protected Level level;
    protected UploadEvent event;
    protected String uploadIndex = "";

    public UploadCallbackAdapter() {
        this.level = Level.FINE;
    }

    public UploadCallbackAdapter(Level level) {
        this.level = level;
    }

    public void uploadStarted(UploadStartEvent event) {
        this.uploadIndex = event.getIndex();
        this.event = event;
        logger.log(this.level, "Upload started for event: " + event.getIndex() + " fileName: " + event.getFileName() + " contentType: " + event.getContentType());
    }

    public void uploadCancelled(UploadCancelEvent event) {
        this.event = event;
        logger.log(this.level, "Upload cancelled for event: " + event.getIndex() + " fileName: " + event.getFileName() + " contentType: " + event.getContentType(), event.getException());
        ((FileUploadSelector)((Object)event.getSource())).removeTaskQueue();
    }

    public void uploadDisallowed(InvalidContentTypeEvent event) {
        this.event = event;
        logger.log(this.level, "Upload disallowed for event: " + event.getIndex() + " fileName: " + event.getFileName() + "with contentType: " + event.getContentType() + " is not of allowed type.");
        ((FileUploadSelector)((Object)event.getSource())).removeTaskQueue();
    }

    public void uploadProgressed(UploadProgressEvent event) {
        if (this.uploadIndex.equals(event.getIndex()) && this.event instanceof UploadFinishEvent) {
            return;
        }
        this.event = event;
        logger.log(this.level, "Upload progress read bytes : " + event.getProgress().getBytesRead());
    }

    public void uploadSucceeded(UploadFinishEvent event) {
        this.event = event;
        logger.log(this.level, "Upload completed for event: " + event.getIndex() + " fileName: " + event.getFileName() + " size: " + event.getFileSize() + " contentType: " + event.getContentType());
        ((FileUploadSelector)((Object)event.getSource())).removeTaskQueue();
    }

    public void uploadFailed(UploadFailEvent event) {
        if (this.uploadIndex.equals(event.getIndex()) && this.event instanceof InvalidContentTypeEvent) {
            return;
        }
        this.event = event;
        logger.log(this.level, "Upload failed for event: " + event.getIndex(), event.getException());
        ((FileUploadSelector)((Object)event.getSource())).removeTaskQueue();
    }

    public UploadEvent getEvent() {
        return this.event;
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        this.level = level;
    }
}

