/*
 * Decompiled with CFR 0.152.
 */
package echopoint.tucana.event;

import echopoint.tucana.event.DownloadCallback;
import echopoint.tucana.event.DownloadFailEvent;
import echopoint.tucana.event.DownloadFinishEvent;
import echopoint.tucana.event.DownloadStartEvent;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DownloadCallbackAdapter
implements DownloadCallback {
    private static final long serialVersionUID = 1L;
    protected static final Logger logger = Logger.getAnonymousLogger();
    protected Level level;

    public DownloadCallbackAdapter() {
        this.level = Level.FINE;
    }

    public DownloadCallbackAdapter(Level level) {
        this.level = level;
    }

    public void downloadStarted(DownloadStartEvent event) {
        logger.log(this.level, "Download of file: " + event.getFileName() + ", of size: " + event.getContentLength() + ", and contentType: " + event.getContentType() + " started");
    }

    public void downloadFinished(DownloadFinishEvent event) {
        logger.log(this.level, "Download of file: " + event.getFileName() + ", of size: " + event.getContentLength() + ", and contentType: " + event.getContentType() + " finished");
    }

    public void downloadFailed(DownloadFailEvent event) {
        logger.log(this.level, "Download of file: " + event.getFileName() + ", of size: " + event.getContentLength() + ", and contentType: " + event.getContentType() + " failed", event.getException());
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        this.level = level;
    }
}

