/*
 * Decompiled with CFR 0.152.
 */
package echopoint.tucana.event;

import echopoint.tucana.event.UploadCallbackAdapter;
import echopoint.tucana.event.UploadFinishEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;

public class DefaultUploadCallback
extends UploadCallbackAdapter {
    private static final long serialVersionUID = 1L;
    protected static final String FILE_SEPARATOR = System.getProperty("file.separator");
    protected static final String TEMP_DIR = System.getProperty("java.io.tmpdir");
    private File directory;

    protected DefaultUploadCallback() {
    }

    public DefaultUploadCallback(File directory) throws IllegalArgumentException {
        this.setDirectory(directory);
    }

    public void uploadSucceeded(UploadFinishEvent event) {
        File temp = this.getTempFile();
        File file = this.getFileName(event.getFileName());
        try {
            event.getFileItem().write(temp);
            if (!temp.renameTo(file)) {
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
                BufferedInputStream bis = new BufferedInputStream(new FileInputStream(temp));
                IOUtils.copy((InputStream)bis, (OutputStream)bos);
                bis.close();
                bos.close();
                temp.delete();
                logger.log(this.level, "Rename of temp file to " + file.getAbsolutePath() + " failed.  Recopied from source.");
            }
            event.getFileItem().delete();
            logger.log(this.level, "Copied upload file contents to: " + file.getAbsolutePath());
        }
        catch (Exception e) {
            throw new RuntimeException("Error copying uploaded file!", e);
        }
        super.uploadSucceeded(event);
    }

    protected File getFileName(String name) {
        return new File(this.directory.getAbsolutePath() + FILE_SEPARATOR + name);
    }

    protected File getTempFile() {
        return new File(this.directory.getAbsolutePath() + FILE_SEPARATOR + "echopoint.tempfile." + System.currentTimeMillis() + ".tmp");
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setDirectory(File directory) throws IllegalArgumentException {
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("File specified must be a directory!");
        }
        this.directory = directory;
    }
}

