/*
 * Decompiled with CFR 0.152.
 */
package echopoint.tucana;

import echopoint.tucana.BaseUploadService;
import echopoint.tucana.FileUploadSelector;
import echopoint.tucana.FileUploadSelectorPeer;
import echopoint.tucana.UploadProgress;
import echopoint.tucana.UploadProviderFactory;
import echopoint.tucana.UploadRenderState;
import echopoint.tucana.event.UploadCallback;
import echopoint.tucana.event.UploadCancelEvent;
import echopoint.tucana.event.UploadFailEvent;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import nextapp.echo.app.ApplicationInstance;
import nextapp.echo.webcontainer.Connection;
import nextapp.echo.webcontainer.Service;
import nextapp.echo.webcontainer.WebContainerServlet;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public class UploadReceiverService
extends BaseUploadService {
    private static final Service INSTANCE = new UploadReceiverService();
    private static boolean installed = false;

    private UploadReceiverService() {
    }

    public static void install() {
        if (!installed) {
            installed = true;
            WebContainerServlet.setMultipartRequestWrapper((WebContainerServlet.MultipartRequestWrapper)UploadProviderFactory.getUploadProvider());
        }
    }

    public String getId() {
        return "echopoint.tucana.UploadReceiverService";
    }

    public int getVersion() {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(Connection conn, FileUploadSelector uploadSelect, String uploadIndex) throws IOException {
        HttpServletRequest request = conn.getRequest();
        ApplicationInstance app = conn.getUserInstance().getApplicationInstance();
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            UploadReceiverService.serviceBadRequest(conn, "Request must contain multipart content.");
            return;
        }
        String contentLengthHeader = request.getHeader("Content-Length");
        long contentLength = contentLengthHeader != null ? Math.max(Long.parseLong(contentLengthHeader), -1L) : -1L;
        UploadRenderState renderState = FileUploadSelectorPeer.getRenderState(uploadSelect, conn.getUserInstance());
        UploadCallback callback = uploadSelect.getUploadCallback();
        String fileName = callback != null && callback.getEvent() != null ? callback.getEvent().getFileName() : null;
        try {
            UploadProgress progress = new UploadProgress(contentLength);
            renderState.setProgress(uploadIndex, progress);
            renderState.uploadStarted(uploadIndex);
            UploadProviderFactory.getUploadProvider().handleUpload(conn, uploadSelect, uploadIndex, progress);
        }
        catch (IllegalStateException e) {
            app.enqueueTask(uploadSelect.getTaskQueue(), (Runnable)new Cancel(uploadSelect, uploadIndex, fileName, e));
        }
        catch (Exception e) {
            app.enqueueTask(uploadSelect.getTaskQueue(), (Runnable)new Fail(uploadSelect, uploadIndex, e));
        }
        finally {
            renderState.uploadEnded(uploadIndex);
        }
    }

    static {
        WebContainerServlet.getServiceRegistry().add(INSTANCE);
    }

    private class Fail
    implements Runnable {
        private final FileUploadSelector uploadSelect;
        private final String uploadIndex;
        private final Exception e;

        private Fail(FileUploadSelector uploadSelect, String uploadIndex, Exception e) {
            this.uploadSelect = uploadSelect;
            this.uploadIndex = uploadIndex;
            this.e = e;
        }

        public void run() {
            this.uploadSelect.notifyCallback(new UploadFailEvent(this.uploadSelect, this.uploadIndex, null, null, this.e));
        }
    }

    private class Cancel
    implements Runnable {
        private final FileUploadSelector uploadSelect;
        private final String uploadIndex;
        private final String fileName;
        private final Exception e;

        private Cancel(FileUploadSelector uploadSelect, String uploadIndex, String fileName, Exception e) {
            this.uploadSelect = uploadSelect;
            this.uploadIndex = uploadIndex;
            this.fileName = fileName;
            this.e = e;
        }

        public void run() {
            this.uploadSelect.notifyCallback(new UploadCancelEvent(this.uploadSelect, this.uploadIndex, this.fileName, null, this.e));
        }
    }
}

