/*
 * Decompiled with CFR 0.152.
 */
package echopoint.tucana;

import echopoint.tucana.BaseUploadService;
import echopoint.tucana.FileUploadSelector;
import echopoint.tucana.FileUploadSelectorPeer;
import echopoint.tucana.UploadProgress;
import echopoint.tucana.UploadRenderState;
import echopoint.tucana.event.UploadProgressEvent;
import java.io.IOException;
import nextapp.echo.webcontainer.Connection;
import nextapp.echo.webcontainer.ContentType;
import nextapp.echo.webcontainer.Service;
import nextapp.echo.webcontainer.WebContainerServlet;

public class UploadProgressService
extends BaseUploadService {
    private static final Service INSTANCE = new UploadProgressService();

    private UploadProgressService() {
    }

    public static void install() {
    }

    public String getId() {
        return "echopoint.tucana.UploadProgressService";
    }

    public int getVersion() {
        return -1;
    }

    public void service(Connection conn, FileUploadSelector uploadSelect, String uploadIndex) throws IOException {
        UploadRenderState renderState = FileUploadSelectorPeer.getRenderState(uploadSelect, conn.getUserInstance());
        UploadProgress progress = renderState.getProgress(uploadIndex);
        StringBuilder buff = new StringBuilder(128);
        if (progress != null && progress.getBytesRead() > 0L) {
            if (!renderState.isUploadEnded(uploadIndex)) {
                uploadSelect.notifyCallback(new UploadProgressEvent(uploadSelect, uploadIndex, progress));
            }
            buff.append("{");
            buff.append("r:").append(progress.getBytesRead()).append(",");
            buff.append("cl:").append(progress.getContentLength()).append(",");
            buff.append("pc:").append(progress.getPercentCompleted()).append(",");
            buff.append("tr:").append(progress.getTransferRate()).append(",");
            buff.append("tl:").append(progress.getEstimatedTimeLeft()).append(",");
            buff.append("s:'").append((Object)progress.getStatus()).append("',");
            buff.append("m:'").append(progress.getMessage()).append("'");
            buff.append("}");
        } else {
            buff.append("{r:0,cl:0,pc:0,tr:0,tl:0,s:'failed',m:''}");
        }
        conn.setContentType(ContentType.TEXT_PLAIN);
        conn.getWriter().write(buff.toString());
        conn.getWriter().flush();
    }

    static {
        WebContainerServlet.getServiceRegistry().add(INSTANCE);
    }
}

