/*
 * Decompiled with CFR 0.152.
 */
package echopoint.tucana;

import echopoint.tucana.Status;
import java.io.Serializable;
import java.util.LinkedList;

public class UploadProgress
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int MINIMUM_MILESTONE_COUNT = 2;
    private static final int MAXIMUM_MILESTONE_COUNT = 10;
    private static final int MILESTONE_INTERVAL = 250;
    private static final int MILESTONE_BYTE_INTERVAL = 2560;
    private final long contentLength;
    private long bytesRead;
    private final LinkedList<Milestone> milestones;
    private long lastMilestoneBytesRead;
    private Status status = Status.inprogress;
    private String message = "";

    public UploadProgress(long contentLength) {
        this.contentLength = contentLength;
        this.milestones = new LinkedList();
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public float getPercentCompleted() {
        if (this.contentLength == -1L) {
            return -1.0f;
        }
        if (this.contentLength == 0L) {
            return 1.0f;
        }
        return (float)this.bytesRead / (float)this.contentLength * 100.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTransferRate() {
        Milestone lastMarker;
        Milestone firstMarker;
        LinkedList<Milestone> linkedList = this.milestones;
        synchronized (linkedList) {
            if (this.milestones.size() < 2) {
                return -1L;
            }
            firstMarker = this.milestones.getFirst();
            lastMarker = this.milestones.getLast();
        }
        long byteDiff = lastMarker.bytesRead - firstMarker.bytesRead;
        long timeDiff = lastMarker.timeStamp - firstMarker.timeStamp;
        return byteDiff * 1000L / timeDiff;
    }

    public int getEstimatedTimeLeft() {
        if (this.contentLength == -1L) {
            return -1;
        }
        if (this.contentLength == this.bytesRead) {
            return 0;
        }
        long transferRate = this.getTransferRate();
        if (transferRate == -1L) {
            return -1;
        }
        return Math.round((this.contentLength - this.bytesRead) / transferRate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBytesRead(long bytesRead) {
        this.bytesRead = bytesRead;
        if (this.lastMilestoneBytesRead > 0L && bytesRead - this.lastMilestoneBytesRead < 2560L) {
            return;
        }
        LinkedList<Milestone> linkedList = this.milestones;
        synchronized (linkedList) {
            long now = System.currentTimeMillis();
            if (this.milestones.isEmpty() || now >= this.milestones.getLast().timeStamp + 250L) {
                this.milestones.add(new Milestone(bytesRead, now));
                this.lastMilestoneBytesRead = bytesRead;
                if (this.milestones.size() > 10) {
                    this.milestones.removeFirst();
                }
            }
        }
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    private static final class Milestone
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final long bytesRead;
        private final long timeStamp;

        private Milestone(long bytesRead, long timeStamp) {
            this.bytesRead = bytesRead;
            this.timeStamp = timeStamp;
        }
    }
}

