/*
 * Decompiled with CFR 0.152.
 */
package echopoint.tucana;

import echopoint.tucana.AbstractFileUploadProvider;
import echopoint.tucana.CancelRunnable;
import echopoint.tucana.FailRunnable;
import echopoint.tucana.FileUploadSelector;
import echopoint.tucana.FinishRunnable;
import echopoint.tucana.InvalidContentTypeRunnable;
import echopoint.tucana.Status;
import echopoint.tucana.UploadProgress;
import echopoint.tucana.UploadProgressListener;
import echopoint.tucana.UploadSizeLimitExceededException;
import echopoint.tucana.event.UploadStartEvent;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import nextapp.echo.app.ApplicationInstance;
import nextapp.echo.webcontainer.Connection;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.MultipartStream;
import org.apache.commons.fileupload.ProgressListener;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class JakartaCommonsFileUploadProvider
extends AbstractFileUploadProvider {
    public void handleUpload(Connection conn, FileUploadSelector uploadSelect, String uploadIndex, UploadProgress progress) throws Exception {
        ApplicationInstance app = conn.getUserInstance().getApplicationInstance();
        DiskFileItemFactory itemFactory = new DiskFileItemFactory();
        itemFactory.setRepository(this.getDiskCacheLocation());
        itemFactory.setSizeThreshold(this.getMemoryCacheThreshold());
        String encoding = conn.getRequest().getCharacterEncoding();
        if (encoding == null) {
            encoding = "UTF-8";
        }
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)itemFactory);
        upload.setHeaderEncoding(encoding);
        upload.setProgressListener((ProgressListener)new UploadProgressListener(progress));
        long sizeLimit = uploadSelect.getUploadSizeLimit();
        if (sizeLimit == 0L) {
            sizeLimit = this.getFileUploadSizeLimit();
        }
        if (sizeLimit != -1L) {
            upload.setSizeMax(sizeLimit);
        }
        String fileName = null;
        String contentType = null;
        try {
            FileItemStream stream;
            FileItemIterator iter = upload.getItemIterator(conn.getRequest());
            if (iter.hasNext() && !(stream = iter.next()).isFormField()) {
                fileName = FilenameUtils.getName((String)stream.getName());
                contentType = stream.getContentType();
                Set<String> types = uploadSelect.getContentTypeFilter();
                if (!types.isEmpty() && !types.contains(contentType)) {
                    app.enqueueTask(uploadSelect.getTaskQueue(), (Runnable)new InvalidContentTypeRunnable(uploadSelect, uploadIndex, fileName, contentType, progress));
                    return;
                }
                progress.setStatus(Status.inprogress);
                uploadSelect.notifyCallback(new UploadStartEvent(uploadSelect, uploadIndex, fileName, contentType));
                FileItem item = itemFactory.createItem(fileName, contentType, false, stream.getName());
                IOUtils.copy((InputStream)stream.openStream(), (OutputStream)item.getOutputStream());
                app.enqueueTask(uploadSelect.getTaskQueue(), (Runnable)new FinishRunnable(uploadSelect, uploadIndex, fileName, item, progress));
                return;
            }
            app.enqueueTask(uploadSelect.getTaskQueue(), (Runnable)new FailRunnable(uploadSelect, uploadIndex, fileName, contentType, new RuntimeException("No multi-part content!"), progress));
        }
        catch (FileUploadBase.SizeLimitExceededException e) {
            app.enqueueTask(uploadSelect.getTaskQueue(), (Runnable)new FailRunnable(uploadSelect, uploadIndex, fileName, contentType, new UploadSizeLimitExceededException(e), progress));
        }
        catch (FileUploadBase.FileSizeLimitExceededException e) {
            app.enqueueTask(uploadSelect.getTaskQueue(), (Runnable)new FailRunnable(uploadSelect, uploadIndex, fileName, contentType, new UploadSizeLimitExceededException(e), progress));
        }
        catch (MultipartStream.MalformedStreamException e) {
            app.enqueueTask(uploadSelect.getTaskQueue(), (Runnable)new CancelRunnable(uploadSelect, uploadIndex, fileName, contentType, (Exception)((Object)e), progress));
        }
    }
}

