/*
 * Decompiled with CFR 0.152.
 */
package echopoint.tucana;

import echopoint.ProgressBar;
import echopoint.internal.AbstractContainer;
import echopoint.tucana.ButtonDisplay;
import echopoint.tucana.ButtonMode;
import echopoint.tucana.event.DefaultUploadListener;
import echopoint.tucana.event.InvalidContentTypeEvent;
import echopoint.tucana.event.UploadCallback;
import echopoint.tucana.event.UploadCancelEvent;
import echopoint.tucana.event.UploadEvent;
import echopoint.tucana.event.UploadFailEvent;
import echopoint.tucana.event.UploadFinishEvent;
import echopoint.tucana.event.UploadProgressEvent;
import echopoint.tucana.event.UploadStartEvent;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import nextapp.echo.app.ApplicationInstance;
import nextapp.echo.app.Component;
import nextapp.echo.app.ImageReference;
import nextapp.echo.app.TaskQueueHandle;
import nextapp.echo.app.event.ActionEvent;
import nextapp.echo.app.event.ActionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUploadSelector
extends AbstractContainer {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_BUTTON_TEXT_UPLOAD = "buttonTextUpload";
    public static final String PROPERTY_BUTTON_TEXT_CANCEL = "buttonTextCancel";
    public static final String PROPERTY_BUTTON_TEXT_WAIT = "buttonTextWait";
    public static final String PROPERTY_BUTTON_IMAGE_UPLOAD = "buttonImageUpload";
    public static final String PROPERTY_BUTTON_IMAGE_CANCEL = "buttonImageCancel";
    public static final String PROPERTY_BUTTON_IMAGE_WAIT = "buttonImageWait";
    public static final String PROPERTY_BUTTON_MODE = "buttonMode";
    public static final String PROPERTY_BUTTON_DISPLAY = "buttonDisplay";
    public static final String PROPERTY_CANCEL_ENABLED = "cancelEnabled";
    public static final String PROPERTY_INPUT_SIZE = "inputSize";
    public static final String PROPERTY_POLLING_INTERVAL = "pollingInterval";
    public static final String PROPERTY_UPLOAD_SIZE_LIMIT = "uploadSizeLimit";
    public static final String COMPLETE_ACTION = "complete";
    public static final String START_ACTION = "start";
    private UploadCallback callback = null;
    private Set<String> contentTypeFilter = new HashSet<String>();
    private TaskQueueHandle taskQueue;

    public FileUploadSelector() {
        this.addActionListener(new DefaultUploadListener());
    }

    public void setButtonUploadImage(ImageReference image) {
        this.set(PROPERTY_BUTTON_IMAGE_UPLOAD, image);
    }

    public ImageReference getButtonUploadImage() {
        return (ImageReference)this.get(PROPERTY_BUTTON_IMAGE_UPLOAD);
    }

    public void setButtonCancelImage(ImageReference image) {
        this.set(PROPERTY_BUTTON_IMAGE_CANCEL, image);
    }

    public ImageReference getButtonCancelImage() {
        return (ImageReference)this.get(PROPERTY_BUTTON_IMAGE_CANCEL);
    }

    public void setButtonWaitImage(ImageReference image) {
        this.set(PROPERTY_BUTTON_IMAGE_WAIT, image);
    }

    public ImageReference getButtonWaitImage() {
        return (ImageReference)this.get(PROPERTY_BUTTON_IMAGE_WAIT);
    }

    public void setButtonUploadText(String text) {
        this.set(PROPERTY_BUTTON_TEXT_UPLOAD, text);
    }

    public String getButtonUploadText() {
        return (String)this.get(PROPERTY_BUTTON_TEXT_UPLOAD);
    }

    public void setButtonCancelText(String text) {
        this.set(PROPERTY_BUTTON_TEXT_CANCEL, text);
    }

    public String getButtonCancelText() {
        return (String)this.get(PROPERTY_BUTTON_TEXT_CANCEL);
    }

    public void setButtonWaitText(String text) {
        this.set(PROPERTY_BUTTON_TEXT_WAIT, text);
    }

    public String getButtonWaitText() {
        return (String)this.get(PROPERTY_BUTTON_TEXT_WAIT);
    }

    public void setButtonMode(ButtonMode mode) {
        this.set(PROPERTY_BUTTON_MODE, (Object)mode);
    }

    public ButtonMode getButtonMode() {
        ButtonMode mode = (ButtonMode)((Object)this.get(PROPERTY_BUTTON_MODE));
        return mode == null ? ButtonMode.submit : mode;
    }

    public void setButtonDisplayMode(ButtonDisplay mode) {
        this.set(PROPERTY_BUTTON_DISPLAY, (Object)mode);
    }

    public ButtonDisplay getButtonDisplayMode() {
        ButtonDisplay display = (ButtonDisplay)((Object)this.get(PROPERTY_BUTTON_DISPLAY));
        return display == null ? ButtonDisplay.auto : display;
    }

    public void setCancelEnabled(boolean enabled) {
        this.set(PROPERTY_CANCEL_ENABLED, enabled);
    }

    public boolean isCancelEnabled() {
        return (Boolean)this.get(PROPERTY_CANCEL_ENABLED);
    }

    public int getInputSize() {
        return (Integer)this.get(PROPERTY_INPUT_SIZE);
    }

    public void setInputSize(int size) {
        this.set(PROPERTY_INPUT_SIZE, size);
    }

    public int getPollingInterval() {
        return (Integer)this.get(PROPERTY_POLLING_INTERVAL);
    }

    public void setPollingInterval(int interval) {
        this.set(PROPERTY_POLLING_INTERVAL, interval);
    }

    public long getUploadSizeLimit() {
        Object obj = this.get(PROPERTY_UPLOAD_SIZE_LIMIT);
        return obj == null ? 0L : (Long)obj;
    }

    public void setUploadSizeLimit(long limit) {
        this.set(PROPERTY_UPLOAD_SIZE_LIMIT, limit);
    }

    public void setUploadCallback(UploadCallback callback) {
        this.callback = callback;
    }

    public UploadCallback getUploadCallback() {
        return this.callback;
    }

    public ProgressBar getProgressBar() {
        return this.getComponentCount() > 0 ? (ProgressBar)this.getComponent(0) : null;
    }

    public void setProgressBar(ProgressBar progressBar) {
        this.add(progressBar, 0);
    }

    public Set<String> getContentTypeFilter() {
        return Collections.unmodifiableSet(this.contentTypeFilter);
    }

    public void setContentTypeFilter(Set<String> contentTypeFilter) {
        this.contentTypeFilter.clear();
        if (contentTypeFilter != null) {
            this.contentTypeFilter.addAll(contentTypeFilter);
        }
    }

    public boolean isValidChild(Component child) {
        boolean result = child instanceof ProgressBar;
        return result && this.getComponentCount() < 2;
    }

    public TaskQueueHandle getTaskQueue() {
        return this.taskQueue;
    }

    public void setTaskQueue(TaskQueueHandle taskQueue) {
        this.taskQueue = taskQueue;
    }

    public void removeTaskQueue() {
        if (this.taskQueue != null) {
            ApplicationInstance.getActive().removeTaskQueue(this.taskQueue);
            this.taskQueue = null;
        }
    }

    protected void notifyCallback(UploadEvent e) {
        if (this.callback == null) {
            return;
        }
        if (e instanceof UploadCancelEvent) {
            this.callback.uploadCancelled((UploadCancelEvent)e);
        }
        if (e instanceof InvalidContentTypeEvent) {
            this.callback.uploadDisallowed((InvalidContentTypeEvent)e);
        } else if (e instanceof UploadFailEvent) {
            this.callback.uploadFailed((UploadFailEvent)e);
        } else if (e instanceof UploadFinishEvent) {
            this.callback.uploadSucceeded((UploadFinishEvent)e);
        } else if (e instanceof UploadProgressEvent) {
            this.callback.uploadProgressed((UploadProgressEvent)e);
        } else if (e instanceof UploadStartEvent) {
            this.callback.uploadStarted((UploadStartEvent)e);
        }
    }

    @Override
    public void addActionListener(ActionListener listener) {
        super.addActionListener(listener);
    }

    @Override
    public void removeActionListener(ActionListener listener) {
        super.removeActionListener(listener);
    }

    public void processInput(String name, Object value) {
        super.processInput(name, value);
        if (COMPLETE_ACTION.equals(name)) {
            this.fireActionPerformed(new ActionEvent((Object)this, name));
        } else if (START_ACTION.equals(name)) {
            this.fireActionPerformed(new ActionEvent((Object)this, name));
        }
    }

    public void dispose() {
        this.removeTaskQueue();
    }
}

