/*
 * Decompiled with CFR 0.152.
 */
package echopoint.tucana;

import echopoint.tucana.AbstractDownloadProvider;
import echopoint.tucana.Status;
import eu.medsea.util.MimeUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;

public class FileDownloadProvider
extends AbstractDownloadProvider {
    private static final long serialVersionUID = 1L;
    private final File file;

    public FileDownloadProvider(File file) {
        this.file = file;
        this.fileName = file.getName();
        this.size = file.length();
    }

    public String getContentType() {
        return this.contentType != null ? this.contentType : MimeUtil.getMimeType((File)this.file);
    }

    public void writeFile(OutputStream out) throws IOException {
        this.status = Status.inprogress;
        try {
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(this.file));
            IOUtils.copy((InputStream)bis, (OutputStream)out);
            out.flush();
            bis.close();
        }
        catch (IOException e) {
            this.status = Status.failed;
            throw e;
        }
        this.status = Status.completed;
    }
}

