/*
 * Decompiled with CFR 0.152.
 */
package echopoint.tucana;

import echopoint.tucana.DownloadCommand;
import echopoint.tucana.DownloadCommandPeer;
import echopoint.tucana.DownloadProvider;
import echopoint.tucana.event.DownloadFailEvent;
import echopoint.tucana.event.DownloadFinishEvent;
import echopoint.tucana.event.DownloadStartEvent;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;
import nextapp.echo.webcontainer.Connection;
import nextapp.echo.webcontainer.ContentType;
import nextapp.echo.webcontainer.Service;
import nextapp.echo.webcontainer.UserInstance;
import nextapp.echo.webcontainer.WebContainerServlet;

public class DownloadService
implements Service {
    static final String SERVICE_ID = "echopoint.tucana.DownloadService";
    private static final String HTTPS = "https";
    private static final String PARAMETER_DOWNLOAD_UID = "duid";
    private static final String[] URL_PARAMETERS = new String[]{"duid"};
    private static final DownloadService INSTANCE = new DownloadService();

    public static void install() {
        WebContainerServlet.getServiceRegistry().add((Service)INSTANCE);
    }

    private DownloadService() {
    }

    public String createUri(UserInstance userInstance, String downloadId) {
        return userInstance.getServiceUri((Service)this, URL_PARAMETERS, new String[]{downloadId});
    }

    public String getId() {
        return SERVICE_ID;
    }

    public int getVersion() {
        return -1;
    }

    public void service(Connection conn) throws IOException {
        UserInstance userInstance = conn.getUserInstance();
        if (userInstance == null) {
            this.serviceBadRequest(conn, "No container available.");
            return;
        }
        String downloadId = conn.getRequest().getParameter(PARAMETER_DOWNLOAD_UID);
        if (downloadId == null) {
            this.serviceBadRequest(conn, "Download UID not specified.");
            return;
        }
        DownloadCommand download = DownloadCommandPeer.getAndRemoveDownload(downloadId);
        if (download == null) {
            this.serviceBadRequest(conn, "Download UID is not valid.");
            return;
        }
        this.service(conn, download);
    }

    private void service(Connection conn, DownloadCommand download) throws IOException {
        String contentType;
        OutputStream out = conn.getOutputStream();
        DownloadProvider provider = download.getProvider();
        HttpServletResponse response = conn.getResponse();
        if (provider.getFileName() == null) {
            response.setHeader("Content-Disposition", provider.getContentDisposition());
        } else {
            response.setHeader("Content-Disposition", provider.getContentDisposition() + "; filename=\"" + provider.getFileName() + "\"");
        }
        if (provider.getSize() > 0L) {
            response.setHeader("Content-Length", String.valueOf(provider.getSize()));
        }
        if ((contentType = provider.getContentType()) == null) {
            response.setContentType("application/octet-stream");
        } else {
            response.setContentType(provider.getContentType());
        }
        try {
            download.notifyCallback(new DownloadStartEvent(download, provider));
            if (HTTPS.equals(conn.getRequest().getScheme()) && conn.getUserInstance().getClientProperties().getBoolean("browserInternetExplorer")) {
                response.setHeader("Cache-Control", "");
                response.setHeader("Pragma", "");
            }
            provider.writeFile(out);
            download.notifyCallback(new DownloadFinishEvent(download, provider));
        }
        catch (Exception e) {
            download.notifyCallback(new DownloadFailEvent(download, provider, e));
        }
    }

    private void serviceBadRequest(Connection conn, String message) {
        conn.getResponse().setStatus(400);
        conn.setContentType(ContentType.TEXT_PLAIN);
        conn.getWriter().write(message);
    }

    public static DownloadService getInstance() {
        return INSTANCE;
    }
}

