/*
 * Decompiled with CFR 0.152.
 */
package echopoint.tucana;

import echopoint.internal.CommonResources;
import echopoint.internal.CommonService;
import echopoint.tucana.DownloadCommand;
import echopoint.tucana.DownloadService;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import nextapp.echo.app.Command;
import nextapp.echo.app.util.Context;
import nextapp.echo.webcontainer.AbstractCommandSynchronizePeer;
import nextapp.echo.webcontainer.ServerMessage;
import nextapp.echo.webcontainer.Service;
import nextapp.echo.webcontainer.UserInstance;
import nextapp.echo.webcontainer.WebContainerServlet;
import nextapp.echo.webcontainer.service.JavaScriptService;

public class DownloadCommandPeer
extends AbstractCommandSynchronizePeer {
    private static final Map<String, DownloadCommand> ID_TO_DOWNLOAD_MAP = new ConcurrentHashMap<String, DownloadCommand>();
    private static final Service DOWNLOAD_SERVICE = JavaScriptService.forResource((String)DownloadCommand.class.getName(), (String)"resource/js/tucana/DownloadService.js");

    public DownloadCommandPeer() {
        this.addProperty("uri", new AbstractCommandSynchronizePeer.PropertyPeer(){

            public Object getProperty(Context context, Command command) {
                DownloadCommand download = (DownloadCommand)command;
                UserInstance userInstance = (UserInstance)context.get(UserInstance.class);
                String id = download.getRenderId();
                ID_TO_DOWNLOAD_MAP.put(id, download);
                return DownloadService.getInstance().createUri(userInstance, id);
            }
        });
    }

    public void init(Context context) {
        super.init(context);
        ServerMessage serverMessage = (ServerMessage)context.get(ServerMessage.class);
        serverMessage.addLibrary(CommonService.ECHOPOINT_SERVICE.getId());
        serverMessage.addLibrary(DOWNLOAD_SERVICE.getId());
    }

    public Class getCommandClass() {
        return DownloadCommand.class;
    }

    public static DownloadCommand getAndRemoveDownload(String id) {
        return ID_TO_DOWNLOAD_MAP.remove(id);
    }

    static {
        CommonResources.install();
        DownloadService.install();
        WebContainerServlet.getServiceRegistry().add(DOWNLOAD_SERVICE);
    }
}

