/*
 * Decompiled with CFR 0.152.
 */
package echopoint.template.ui;

import echopoint.template.TemplateCompilerHints;
import echopoint.template.TemplateDataSource;
import echopoint.template.ui.TemplateCompiler;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import nextapp.echo.webcontainer.Connection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class XHTMLTemplateCompiler
implements TemplateCompiler {
    private static final ThreadLocal nonvalidatingDocumentBuilders = new ThreadLocal(){

        protected Object initialValue() {
            return XHTMLTemplateCompiler.buildDocumentBuilder(null);
        }
    };

    protected static final DocumentBuilder buildDocumentBuilder(TemplateCompilerHints compilerHints) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            if (compilerHints == null) {
                factory.setNamespaceAware(true);
                factory.setValidating(false);
                factory.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            } else {
                factory.setCoalescing(compilerHints.isCoalescing());
                factory.setExpandEntityReferences(compilerHints.isExpandEntityReferences());
                factory.setIgnoringComments(compilerHints.isIgnoringComments());
                factory.setIgnoringElementContentWhitespace(compilerHints.isIgnoringElementContentWhitespace());
                factory.setNamespaceAware(compilerHints.isNamespaceAware());
                factory.setValidating(compilerHints.isValidating());
                String[] attrNames = compilerHints.getAttributeNames();
                if (attrNames != null) {
                    for (int i = 0; i < attrNames.length; ++i) {
                        Object value = compilerHints.getAttributeValue(attrNames[i]);
                        factory.setAttribute(attrNames[i], value);
                    }
                }
            }
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder;
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected static DocumentBuilder getNonValidatingDocumentBuilder() {
        return (DocumentBuilder)nonvalidatingDocumentBuilders.get();
    }

    public Element compileTemplateDataIntoXHTML(Connection c, TemplateDataSource tds) throws Exception {
        return this.compileXHTML(tds.getInputStream(), tds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String templateDataAsString(Connection c, TemplateDataSource tds) throws Exception {
        BufferedReader reader = new BufferedReader(new InputStreamReader(tds.getInputStream()));
        StringBuilder sb = new StringBuilder();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
        }
        finally {
            tds.getInputStream().close();
        }
        return sb.toString();
    }

    protected Element compileXHTML(InputStream inputStream, TemplateDataSource tds) throws Exception {
        long startMS = System.currentTimeMillis();
        String characterEncoding = tds.getCharacterEncoding();
        TemplateCompilerHints compilerHints = tds.getCompilerHints();
        InputStreamReader isr = characterEncoding != null ? new InputStreamReader(inputStream, characterEncoding) : new InputStreamReader(inputStream);
        InputSource inputSource = new InputSource();
        inputSource.setCharacterStream(isr);
        inputSource.setByteStream(inputStream);
        inputSource.setEncoding(characterEncoding);
        DocumentBuilder docBuilder = null;
        docBuilder = compilerHints == null ? XHTMLTemplateCompiler.getNonValidatingDocumentBuilder() : XHTMLTemplateCompiler.buildDocumentBuilder(compilerHints);
        Document document = docBuilder.parse(inputSource);
        Element documentElement = document.getDocumentElement();
        long compileMS = System.currentTimeMillis() - startMS;
        if (compileMS == 0L) {
            // empty if block
        }
        return documentElement;
    }
}

