/*
 * Decompiled with CFR 0.152.
 */
package echopoint.template.ui;

import echopoint.template.ui.TemplateCompiler;
import echopoint.util.StringPeerFactory;
import java.util.Map;
import java.util.WeakHashMap;

public class TemplateCompilerLoader {
    private static final String PEERS_PATH = "META-INF/echopoint/template/TemplateCompilers.properties";
    private static final Map classLoaderToLoaderMap = new WeakHashMap();
    private StringPeerFactory peerFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TemplateCompilerLoader forClassLoader(ClassLoader classLoader) {
        Map map = classLoaderToLoaderMap;
        synchronized (map) {
            TemplateCompilerLoader loader = (TemplateCompilerLoader)classLoaderToLoaderMap.get(classLoader);
            if (loader == null) {
                loader = new TemplateCompilerLoader(classLoader);
                classLoaderToLoaderMap.put(classLoader, loader);
            }
            return loader;
        }
    }

    private TemplateCompilerLoader(ClassLoader classLoader) {
        this.peerFactory = new StringPeerFactory(PEERS_PATH, classLoader);
    }

    public TemplateCompiler getTemplateCompiler(String contentType) {
        return (TemplateCompiler)this.peerFactory.getPeer(contentType);
    }
}

