/*
 * Decompiled with CFR 0.152.
 */
package echopoint.template.ui;

import echopoint.template.JspTemplateDataSource;
import echopoint.template.TemplateDataSource;
import echopoint.template.ui.XHTMLTemplateCompiler;
import echopoint.util.io.CapturedHttpServletResponse;
import echopoint.util.throwable.ThrowableKit;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.PageContext;
import nextapp.echo.webcontainer.Connection;
import nextapp.echo.webcontainer.WebContainerServlet;
import org.w3c.dom.Element;

public class JspXHTMLTemplateCompiler
extends XHTMLTemplateCompiler {
    public Element compileTemplateDataIntoXHTML(Connection c, TemplateDataSource tds) throws Exception {
        InputStream inputStream = this.jspExecute(c, (JspTemplateDataSource)tds);
        return this.compileXHTML(inputStream, tds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String templateDataAsString(Connection c, TemplateDataSource tds) throws Exception {
        InputStream inputStream = this.jspExecute(c, (JspTemplateDataSource)tds);
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder sb = new StringBuilder();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
        }
        finally {
            inputStream.close();
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream jspExecute(Connection c, JspTemplateDataSource jspTemplateDataSource) {
        String name;
        int i;
        String jspPath = jspTemplateDataSource.getJspPath();
        WebContainerServlet servlet = c.getServlet();
        HttpServletRequest request = c.getRequest();
        HttpServletResponse wrappedResponse = c.getResponse();
        CapturedHttpServletResponse response = new CapturedHttpServletResponse(wrappedResponse, jspTemplateDataSource.getCharacterEncoding());
        String[] requestAttributes = jspTemplateDataSource.getAttributeNames();
        try {
            for (i = 0; i < requestAttributes.length; ++i) {
                name = requestAttributes[i];
                request.setAttribute(name, jspTemplateDataSource.getAttribute(name));
            }
            this.jspInclude(true, jspPath, (Servlet)servlet, request, response);
        }
        finally {
            for (i = 0; i < requestAttributes.length; ++i) {
                name = requestAttributes[i];
                request.removeAttribute(name);
            }
        }
        return response.getCapturedInputStream();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void jspInclude(boolean isLoudErrorsUsed, String jspPath, Servlet servlet, HttpServletRequest request, HttpServletResponse response) {
        JspFactory factory = null;
        PageContext pc = null;
        PrintWriter out = null;
        try {
            out = response.getWriter();
            factory = JspFactory.getDefaultFactory();
            pc = factory.getPageContext(servlet, (ServletRequest)request, (ServletResponse)response, null, true, 0, true);
            if (pc == null) {
                throw new ServletException("Unable to obtain JSP PageContext object");
            }
            pc.include(jspPath);
            factory.releasePageContext(pc);
            pc = null;
            if (factory == null) return;
            if (pc == null) return;
        }
        catch (ServletException e) {
            if (isLoudErrorsUsed) {
                out.println("<div style=\"background:red;color:white;font-size:12;border-width:1; border-style:solid; border-color:black; padding:4; margin:4\" >");
                out.println("<blink><b>");
                out.println("<p>JSP Exception : '<em>" + (Object)((Object)e) + "</em>'</p>");
                out.println("</b></blink></div>");
            } else {
                out.println("<!-- ");
                out.println("JSP Exception : '" + (Object)((Object)e) + "'");
                out.println(" -->");
            }
            if (factory == null || pc == null) return;
            factory.releasePageContext(pc);
            return;
        }
        catch (IOException e2) {
            throw ThrowableKit.makeRuntimeException(e2);
            {
                catch (Throwable throwable) {
                    if (factory == null || pc == null) throw throwable;
                    factory.releasePageContext(pc);
                    throw throwable;
                }
            }
        }
        factory.releasePageContext(pc);
        return;
    }
}

