/*
 * Decompiled with CFR 0.152.
 */
package echopoint.template;

import echopoint.template.AbstractTemplateDataSource;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class ResourceTemplateDataSource
extends AbstractTemplateDataSource {
    private String resource;
    private String canonicalName;
    private ClassLoader classLoader;

    public ResourceTemplateDataSource(String resource, ClassLoader classLoader) {
        this.resource = resource;
        this.classLoader = classLoader;
        this.canonicalName = "res:" + resource;
    }

    public ResourceTemplateDataSource(String resource) {
        this(resource, Thread.currentThread().getContextClassLoader());
    }

    public ResourceTemplateDataSource() {
        this(null, null);
    }

    public String getCanonicalName() {
        return this.canonicalName;
    }

    public InputStream getInputStream() throws IOException {
        URL url = this.classLoader.getResource(this.resource);
        if (url != null) {
            return url.openStream();
        }
        return null;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }
}

