/*
 * Decompiled with CFR 0.152.
 */
package echopoint.style;

import echopoint.style.AbstractStyle;
import echopoint.style.Background;
import echopoint.style.DefaultFont;
import echopoint.util.ColorKit;
import nextapp.echo.app.Alignment;
import nextapp.echo.app.Extent;
import nextapp.echo.app.Insets;

public class InfoWindowStyle
extends AbstractStyle {
    private static final long serialVersionUID = 1L;
    public static final String BACKGROUND = "#f9f9f9";
    public static final String FOREGROUND = "#a10202";
    public static final String TEXT_BACKGROUND = "#cfdfff";
    public static final String TEXT_FOREGROUND = "#2f2f4f";
    public static final String TITLE_FOREGROUND = "#ffffff";

    protected void init() {
        super.init();
        this.setProperties();
        this.setTextProperties();
        this.setTitleProperties();
    }

    protected void setProperties() {
        this.set("alignment", Alignment.ALIGN_CENTER);
        this.set("background", ColorKit.makeColor(BACKGROUND));
        this.set("foreground", ColorKit.makeColor(FOREGROUND));
        this.set("insets", new Insets(new Extent(10)));
        this.set("width", new Insets(new Extent(250)));
    }

    protected void setTextProperties() {
        this.set("textBackground", ColorKit.makeColor(TEXT_BACKGROUND));
        this.set("textFont", DefaultFont.fontWithStyle("BOLD"));
        this.set("textForeground", ColorKit.makeColor(TEXT_FOREGROUND));
        this.set("textInsets", new Insets(new Extent(3), new Extent(8)));
    }

    protected void setOtherTextProperties() {
        this.set("otherTextForeground", ColorKit.makeColor("#000000"));
        this.set("otherTextInsets", new Insets(new Extent(2), new Extent(5)));
    }

    protected void setTitleProperties() {
        this.set("titleAlignment", Alignment.ALIGN_LEFT);
        this.set("titleBackground", Background.getInstance());
        this.set("titleFont", DefaultFont.getInstance("BOLD", "12px"));
        this.set("titleForeground", ColorKit.makeColor(TITLE_FOREGROUND));
    }
}

